//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.activity.ActivityRequest;
import uk.org.ogsadai.client.toolkit.activity.delivery.DeliverFromURL;
import uk.org.ogsadai.client.toolkit.activity.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activity.transform.XSLTransform;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example shows how to transform a JDBC result set into a
 *  HTML table. The XSL transform document is delivered from the URL:
 *  http://localhost:8080/tutorial/transformRowSet.xsl
 *  To make this file available on your Tomcat server download the file
 *  transformRowSet.xsl from the tutorial pages and copy it into
 *  &lt;TOMCAT-DIR&gt;/webapps/ROOT/tutorial/
 *  Any files or subdirectories in webapps/ROOT/ are automatically
 *  published by Tomcat.
 */

public class XSLTransformWithDelivery {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "MySQLResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Create a delivery object
        String url = "http://localhost:8080/tutorial/transformRowSet.xsl";
        DeliverFromURL deliver = new DeliverFromURL( url );

        // Construct a query
        SQLQuery query  = new SQLQuery("select * from littleblackbook where id<=1000");

        // Construct the transformation activity
        XSLTransform transform = new XSLTransform();
        transform.setXMLInput( query.getOutput() );
        transform.setXSLTInput( deliver.getOutput() );

        // Construct the request
        ActivityRequest request = new ActivityRequest();
        request.add(deliver);
        request.add(query);
        request.add(transform);

        System.out.println("Performing request...");
        service.perform( request );

        System.out.println("Results:\n" + transform.getOutput().getData());

    }
}
