//(c) International Business Machines Corporation, 2002 - 2004.
//(c) University of Edinburgh, 2002 - 2004.
//See OGSA-DAI-Licence.txt for licencing information.

package examples.tutorials.clienttoolkit;

import uk.org.ogsadai.client.toolkit.activity.ActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.activity.xmldb.XUpdate;
import uk.org.ogsadai.client.toolkit.service.DataService;
import uk.org.ogsadai.client.toolkit.wsrf.WSRFServiceFetcher;

/**
 *  This example performs an XUpdate activity.
 */
public class XUpdateExample {

    public static void main(String[] args) throws Exception {

		// set up service URL and resource ID
        String handle = "http://localhost:8080/wsrf/services/ogsadai/DataService";
        String id = "XindiceResource";
        // service handle may be provided as an argument
        if (args.length == 1) {
            handle = args[0];
        }

        // Locate a Data Service
        DataService service = WSRFServiceFetcher.getInstance().getDataService(handle, id);
        System.out.println("Ready to connect to data service at " + service.getURL());

        // Modify an entry
        String xupdate = "<xu:modifications version=\"1.0\" " +
                         "xmlns:xu=\"http://www.xmldb.org/xupdate\">" +
                         "<xu:update select=\"/entry[@id=99]/name\">" +
                         "Harold Bishop" +
                         "</xu:update>" +
                         "</xu:modifications>";
        XUpdate update = new XUpdate( xupdate );
        System.out.println("Performing update...");
        service.perform( update );

        // Print out the results
        ActivityOutput results = update.getOutput();
        System.out.println("Results:\n" + results.getData());

        // Check that the update has been performed
        XPathQuery query = new XPathQuery("/entry[@id=99]");
        service.perform( query );
        results = query.getOutput();
        System.out.println("Modified entry:\n" + results.getData());

        // Undo update
        xupdate = "<xu:modifications " +
                         "version=\"1.0\" " +
                         "xmlns:xu=\"http://www.xmldb.org/xupdate\">" +
                         "<xu:update select=\"/entry[@id=99]/name\">" +
                         "Paul Krause" +
                         "</xu:update>" +
                         "</xu:modifications>";
        update = new XUpdate( xupdate );
        System.out.println("Undoing update...");
        service.perform( update );

        results = update.getOutput();
        System.out.println("Results:\n" + results.getData());

        // Query the results
        query = new XPathQuery("/entry[@id=99]");
        service.perform( query );
        results = query.getOutput();
        System.out.println("Modified entry:\n" + results.getData());

    }
}
