/*
 * Decompiled with CFR 0.152.
 */
package school;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Random;
import school.FileName3D;
import school.FileStore;
import school.FileStoreException;
import school.Render;
import school.RenderException;
import school.ThreeDFile;
import school.XMLGnuConversionException;
import school.XMLToGnuFormat;

public class Visualiser
implements Render {
    public String render(FileName3D fileName3D) throws RenderException {
        String string = System.getProperty("user.home") + "/visualiser";
        String string2 = "";
        File file = new File(string);
        if (!file.exists()) {
            throw new RenderException("Visualiser not set up properly root directory for temp files does not exist");
        }
        try {
            String string3;
            FileStore fileStore = new FileStore();
            ThreeDFile threeDFile = fileStore.fetch3D(fileName3D);
            Random random = new Random();
            int n = random.nextInt(10000);
            String string4 = string + "/Temp" + n + "_" + fileName3D.getFileName() + ".dat";
            String string5 = string4 + "_gnu";
            XMLToGnuFormat xMLToGnuFormat = new XMLToGnuFormat();
            xMLToGnuFormat.convert(threeDFile, string4);
            File file2 = new File(string5);
            if (file2.exists()) {
                throw new IOException("Temporary file for GnuPlot script already exists. Try again");
            }
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            printWriter.println("set terminal post \n splot \"" + string4 + "\" notitle   ");
            printWriter.close();
            String[] stringArray = new String[]{"/usr/bin/gnuplot", string5};
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            process.waitFor();
            File file3 = new File(string4);
            file3.delete();
            file2.delete();
            return stringBuffer.toString();
        }
        catch (FileStoreException fileStoreException) {
            string2 = fileStoreException.getMessage();
        }
        catch (XMLGnuConversionException xMLGnuConversionException) {
            string2 = xMLGnuConversionException.getMessage();
        }
        catch (InterruptedException interruptedException) {
            string2 = " process executing gnuplot interrupted ";
        }
        catch (IOException iOException) {
            string2 = "IOError " + iOException.getMessage();
        }
        throw new RenderException(string2);
    }
}

