/*
 * PointEvaluator1.java
 *
 * Created on 4 July 2005, 13:28
 */

/**
 * Program to generate a single surface height for
 * a predefined surface.
 *
 * @author  sara
 */
public class PointEvaluator1 {
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
	//check the number of command line arguments is correct
        if(args.length != 2){
	    System.err.println("Usage: PointEvaluator1 x y");
	    System.exit(1);
	}

	//enclose the elements of code which throw an exception
	//in a try catch 
	try{
	    //define the box the surface is defined in.
	    final double lx = -10;
	    final double ly = -10;
	    final double ux = 10;
	    final double uy = 10;
	    Box boundary = new Box(lx,ly,ux,uy);

	    //extract x and y from the command line arguments
            double x = Double.parseDouble(args[0]);
            double y = Double.parseDouble(args[1]);

	    //check (x,y) is within the box boundary
	    if(!boundary.inBox(x,y))
		throw new BoxException("Out of Bounds: "+x+" "+y);

	    //create a Surface instance
	    Surface s = new Surface();

	    //write to standard output x,y,h
	    System.out.println("x "+x+" y "+y+" h "+s.surfaceFunction(x,y));
	}
	//include all the exceptions to be caught
	catch(NumberFormatException nfe){
	    System.err.println("Arguments must be numbers");
	}
	catch(BoxException be){
	    System.err.println(be.getMessage());
	}
    }
}       

