/*
 * BatchOFPointsEvaluator1.java
 *
 * Created on 4 July 2005, 13:28
 */
//import statements
import java.io.*;
/**
 * Program to generate a batch of surface heights for
 * a predefined surface.
 *
 * @author  
 */
public class BatchOfPointsEvaluator1 {

    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
	//check the number of command line arguments is correct
        if(args.length != 2){
	    System.err.println("Usage: PointEvaluator2 <file2D> <file3D>");
	    System.exit(1);
	}
	//enclose the elements of code which throw an exception
	//in a try catch 
	try{
	    //define the maximum number of points to be
	    //used

	    //define the box the surface is defined in.

	    //check input file exists and is readable
	    File f = new File(args[0]);
	    if(!f.exists()) throw new IOException("File "+args[0]+
						  " does not exist");
	    if(!f.isFile())throw new IOException("File "+args[0]+
						  " is not a file");
	    if(!f.canRead())throw new IOException("File "+args[0]+
						  " cannot be read");
	    if(f.length() == 0)throw new IOException("File "+args[0]+
						  " is empty");

	    //open the input file
	    BufferedReader br = new BufferedReader(new FileReader(f));

	    //create the output file, not overwriting
	    //any existing file
	    File out = new File(args[1]);
	    if(!out.createNewFile())
		throw new IOException("Cannot create file "+args[1]+
				      " may already exist");

	    //open the output file
	    PrintWriter pw = new PrintWriter(new FileWriter(out));

	    //create a new Surface instance


	    //read in the (x,y) coordinates and calculate h
	    String line;
	    int count = 0;
	    while((line = br.readLine()) != null && 
		  count < maximumBatchSize ){

		//extract x and y

		//check (x,y) is in the box

		//output x,y,h

		count++;
	    }
	    //close input and output files
	    br.close();
	    pw.close();
	}
	//catch all exceptions thrown
	catch(IOException ioe){
	    System.err.println(ioe.getMessage());
	}
	catch(NumberFormatException nfe){
	    System.err.println("Arguments must be numbers");
	}
	catch(BoxException be){
	    System.err.println(be.getMessage());
	}
    }
}       

