/*
 * BigProbe.java
 * Created on 5th July 11:40
 */
import randgen.Box;
import java.io.*;
import java.math.*;
/**
 * Class containing helper methods for sampling a surface
 * @author sara
 */
public class BigProbe{
    //the maximum number of points which can be used to
    //sample a Surface (as restricted by the Surface service)

    //The subdirectory in FileStore where all the files
    //are put. This must be unique, e.g. include your name

    //URL for the  FileStore service


    /** Samples a sub-section of a surface using a specified number of
     * points which are generated randomly. The area to be sampled
     * is defined by a bounding box. 
     * @param boundary the bounding box for the sampling
     * @param count the number of sampling points, count <= 
     * MAX_POINTS (the maximum allowed by the Surface serrvice)
     * @param outName the filename for the 3D sample data
     */
    public static void random(Box boundary, int count, String outName,
			      String surfaceURL){
    }


    /** Samples a sub-section of a surface using a specified number of
     * points which are generated on a regular grid. The area to be sampled
     * is defined by a bounding box. 
     * @param boundary the bounding box for the sampling
     * @param count the number of sampling points, count <= 
     * MAX_POINTS (the maximum allowed by the Surface serrvice)
     * @param outName the filename for the 3D sample data
     */
    public static void regular(Box boundary, int count, 
			       String outName, String surfaceURL){

    }

    /** Concatenates files containing 3D data. The files which
     * are concatenated are deleted.
     * @param filenames the filenames of the data to be concatenated
     * (which are then deleted)
     * @param cat the filename for the output
     */
    public static void concatenate3D(String filenames[], String cat){

    }

    /** Visualises the 3D data by using gnuplot to 
     * generate postscript which is outputted to a file
     * @param filename the 3D data filename
     * @param epsName the postscript filename
     */
    public static void visualise(String filename, String epsName){

    }
    /** converts the 3D data stored in FileStore from XML to
     * a format that can be inputted to gnuplot. The reformatted
     * data is outputted to a file in the local directory
     * @param filename the 3D data filename
     * @param gnuName the output filename
     */
    public static void convert(String filename, String gnuName){

    }
}
