/*
 * Decompiled with CFR 0.152.
 */
package school;

import java.util.Random;
import school.Box;
import school.FileName2D;
import school.FileStore;
import school.FileStoreException;
import school.GeneratorException;
import school.RandomGen;
import school.TwoDFile;

public class RandGen
implements RandomGen {
    public void generate(Box box, int n, FileName2D fileName2D) throws GeneratorException {
        if (n <= 0) {
            throw new GeneratorException("RandGen: count must be >0 not " + n);
        }
        if (!box.check()) {
            throw new GeneratorException("RandGen: bounding box not a valid box");
        }
        String string = "";
        Random random = new Random();
        double d = box.getUpperCornerX();
        double d2 = box.getLowerCornerX();
        double d3 = box.getUpperCornerY();
        double d4 = box.getLowerCornerY();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d2 + random.nextDouble() * (d - d2);
            dArray2[i] = d4 + random.nextDouble() * (d3 - d4);
        }
        TwoDFile twoDFile = new TwoDFile(dArray, dArray2);
        try {
            FileStore fileStore = new FileStore();
            fileStore.store2D(twoDFile, fileName2D);
            return;
        }
        catch (FileStoreException fileStoreException) {
            string = string + fileStoreException.getMessage();
            throw new GeneratorException(string);
        }
    }
}

