/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.impl.wsa;

import com.fujitsu.unicore.services.impl.wsa.WSAddressingHeaders;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.types.URI;

public class WSAddressingServerHandler
extends BasicHandler {
    private SimpleUUIDGen msgId;

    public void invoke(MessageContext context) throws AxisFault {
        context.setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        try {
            if (!context.getPastPivot()) {
                this.processServerRequest(context);
            } else {
                this.processServerResponse(context);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    public void onFault(MessageContext context) {
        try {
            this.processServerResponse(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void processServerRequest(MessageContext serverContext) throws AxisFault {
        this.processRequestHeader(serverContext);
    }

    private void processServerResponse(MessageContext serverContext) throws AxisFault {
        String[] headers = this.getRequestHeader(serverContext);
        if (headers[0] != null && headers[1] != null && headers[2] != null) {
            Message ResponseMessage = serverContext.getResponseMessage();
            try {
                SOAPEnvelope ResponseEnvelope = ResponseMessage.getSOAPEnvelope();
                this.msgId = new SimpleUUIDGen();
                String messageID = this.msgId.nextUUID();
                if (ResponseMessage != null) {
                    try {
                        URI uriAction = new URI(String.valueOf(headers[0]) + "Response");
                        URI uriMsgId = new URI("uuid", messageID);
                        URI uriTo = new URI("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
                        URI uriFrom = new URI(headers[2]);
                        URI uriRelatesTo = new URI(headers[1]);
                        WSAddressingHeaders wsaHeader = new WSAddressingHeaders(uriAction, uriMsgId, uriTo, uriFrom, uriRelatesTo);
                        wsaHeader.setResponseHeader((javax.xml.soap.SOAPEnvelope)ResponseEnvelope);
                    }
                    catch (URI.MalformedURIException melOut) {
                        melOut.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private void processRequestHeader(MessageContext context) throws AxisFault {
        Message RequestMessage = context.getRequestMessage();
        try {
            SOAPHeader requestHeader = RequestMessage.getSOAPEnvelope().getHeader();
            Iterator values = requestHeader.getChildElements();
            while (values.hasNext()) {
                SOAPHeaderElement selem = (SOAPHeaderElement)values.next();
                String name = selem.getLocalName();
                if (name.equals("ResourceDisambiguator")) {
                    context.setProperty("ResourceDisambiguator", (Object)selem);
                }
                selem.setProcessed(true);
            }
        }
        catch (SOAPException soapE) {
            AxisFault a_fault = AxisFault.makeFault((Exception)((Object)soapE));
            throw a_fault;
        }
    }

    private String[] getRequestHeader(MessageContext context) throws AxisFault {
        Message RequestMessage = context.getRequestMessage();
        String[] requestHeaderValues = new String[3];
        try {
            SOAPHeader requestHeader = RequestMessage.getSOAPEnvelope().getHeader();
            Iterator values = requestHeader.getChildElements();
            while (values.hasNext()) {
                SOAPHeaderElement selem = (SOAPHeaderElement)values.next();
                String name = selem.getElementName().getLocalName();
                if (name.equals("Action")) {
                    requestHeaderValues[0] = selem.getValue();
                    continue;
                }
                if (name.equals("MessageID")) {
                    requestHeaderValues[1] = selem.getValue();
                    continue;
                }
                if (!name.equals("To")) continue;
                requestHeaderValues[2] = selem.getValue();
            }
        }
        catch (SOAPException ex) {
            AxisFault a_fault = AxisFault.makeFault((Exception)((Object)ex));
            throw a_fault;
        }
        return requestHeaderValues;
    }

    public List getUnderstoodHeaders() {
        return WSAddressingHeaders.getUnderstoodHeaders();
    }
}

