/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.impl.wsrf;

import com.fujitsu.unicore.services.impl.wsrf.ResourcePropertiesPortTypeImpl;
import com.fujitsu.unicore.services.resourcemgmt.DynamicResourceProperty;
import com.fujitsu.unicore.services.resourcemgmt.ResourceManager;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.oasis.wsrf.lt.Destroy;
import org.oasis.wsrf.lt.DestroyResponse;
import org.oasis.wsrf.lt.ResourceNotDestroyedFaultType;
import org.oasis.wsrf.lt.ResourceUnknownFaultType;
import org.oasis.wsrf.lt.SetTerminationTime;
import org.oasis.wsrf.lt.SetTerminationTimeResponse;
import org.oasis.wsrf.lt.TerminationTimeChangeRejectedFaultType;
import org.oasis.wsrf.lt.UnableToSetTerminationTimeFaultType;
import org.oasis.wsrf.rp.InvalidInsertResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.InvalidResourcePropertyQNameFaultType;
import org.unicore.services.wsrf.lt.ResourceLifetimePortType;

public class ResourceLifetimePortTypeImpl
extends ResourcePropertiesPortTypeImpl
implements ResourceLifetimePortType {
    private Calendar terminationTime;
    private CurrentTime current_time = new CurrentTime(ResourceLifetimePortType.currentTimeQName);
    private static Timer terminationTimer = new Timer(true);
    private myTimerTask terminationWatch = null;

    public ResourceLifetimePortTypeImpl(String service_name, QName rp_document_qname, String rp_schema_filename, Calendar initial_termination_time) {
        super(service_name, rp_document_qname, rp_schema_filename);
        if (initial_termination_time == null) {
            this.terminationTime = new GregorianCalendar();
            this.terminationTime.add(12, 15);
        } else {
            this.terminationTime = initial_termination_time;
        }
        ResourcePropertyObject[] rpo = new ResourcePropertyObject[]{new ResourcePropertyObject(ResourceLifetimePortType.currentTimeQName, this.current_time), new ResourcePropertyObject(ResourceLifetimePortType.terminationTimeQName, this.terminationTime)};
        int i = 0;
        while (i < rpo.length) {
            try {
                this.registerResourceProperty(rpo[i].getName(), true);
                this.addResourceProperty(rpo[i]);
            }
            catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
                fault.printStackTrace();
            }
            catch (InvalidResourcePropertyQNameFaultType irpqf) {
                irpqf.printStackTrace();
            }
            ++i;
        }
    }

    public DestroyResponse destroy(Destroy destroyRequest) throws RemoteException, ResourceNotDestroyedFaultType, ResourceUnknownFaultType {
        try {
            ResourceManager.getRMInstance().deleteResource(this.getEndpointReferenceType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.terminationWatch.cancel();
        DestroyResponse dr = new DestroyResponse();
        return dr;
    }

    public SetTerminationTimeResponse setTerminationTime(SetTerminationTime setTerminationTimeRequest) throws RemoteException, UnableToSetTerminationTimeFaultType, ResourceUnknownFaultType, TerminationTimeChangeRejectedFaultType {
        this.terminationTime = setTerminationTimeRequest.getRequestedTerminationTime();
        QName[] ct_qname = new QName[]{ResourceLifetimePortType.currentTimeQName};
        CurrentTime ct = (CurrentTime)this.getResourceProperties(ct_qname)[0].getProperty();
        Calendar currentTime = (Calendar)ct.getProperty();
        if (this.terminationTime == null || this.terminationTime.getTimeInMillis() <= currentTime.getTimeInMillis()) {
            this.terminationWatch.cancel();
            this.terminationWatch = new myTimerTask(this.getEndpointReferenceType());
            terminationTimer.schedule((TimerTask)this.terminationWatch, currentTime.getTime());
            this.terminationTime = currentTime;
        } else {
            this.terminationWatch.cancel();
            this.terminationWatch = new myTimerTask(this.getEndpointReferenceType());
            terminationTimer.schedule((TimerTask)this.terminationWatch, this.terminationTime.getTime());
        }
        this.clearResourceProperty(ResourceLifetimePortType.terminationTimeQName);
        this.addResourceProperty(new ResourcePropertyObject(ResourceLifetimePortType.terminationTimeQName, this.terminationTime));
        SetTerminationTimeResponse sttr = new SetTerminationTimeResponse();
        sttr.setNewTerminationTime((Calendar)this.getResourceProperties(new QName[]{ResourceLifetimePortType.terminationTimeQName})[0].getProperty());
        sttr.setCurrentTime(currentTime);
        return sttr;
    }

    public void setTimer() {
        this.terminationWatch = new myTimerTask(this.getEndpointReferenceType());
        terminationTimer.schedule((TimerTask)this.terminationWatch, this.terminationTime.getTime());
    }

    private class CurrentTime
    extends DynamicResourceProperty {
        public CurrentTime(QName name) {
            super(name);
        }

        public Object getValue() {
            return new GregorianCalendar();
        }
    }

    private class myTimerTask
    extends TimerTask {
        private EndpointReferenceType target_epr;

        public myTimerTask(EndpointReferenceType epr) {
            this.target_epr = epr;
        }

        public void run() {
            try {
                ResourceManager.getRMInstance().deleteResource(this.target_epr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

