/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.resourcemgmt;

import com.fujitsu.unicore.services.impl.wsa.WSAddressingHeaders;
import com.fujitsu.unicore.services.resourcemgmt.IResourceManager;
import com.fujitsu.unicore.services.resourcemgmt.IWSResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.namespace.QName;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.AttributedQName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.types.URI;
import org.oasis.wsrf.rp.ResourceUnknownFaultType;

public class ResourceManager
implements IResourceManager {
    private Map resources;
    private static Timer resourceChecker;
    private static LifetimeChecker timer;
    private static long DELAY;
    private static ResourceManager resourceManager;
    private SimpleUUIDGen key_generator = new SimpleUUIDGen();
    private static boolean initialized;

    static {
        DELAY = 60000L;
        initialized = false;
    }

    public ResourceManager() {
        this.resources = Collections.synchronizedMap(new HashMap());
    }

    public static ResourceManager getRMInstance() {
        ResourceManager.init();
        return resourceManager;
    }

    public synchronized EndpointReferenceType addResource(IWSResource resource) {
        String disambiguator = null;
        if (this.resources.containsValue(resource)) {
            Iterator it = this.resources.entrySet().iterator();
            while (it.hasNext() && disambiguator == null) {
                Map.Entry entry = it.next();
                if (!entry.getValue().equals(resource)) continue;
                disambiguator = (String)entry.getKey();
            }
        } else {
            disambiguator = this.key_generator.nextUUID();
            this.resources.put(disambiguator, resource);
        }
        EndpointReferenceType epr = new EndpointReferenceType();
        try {
            String host = System.getProperty("host");
            if (host == null) {
                System.err.print("Please add host IP address into the configuration file");
                System.exit(1);
            } else {
                AttributedURI endpoint_uri = new AttributedURI("http://" + host + ":7000/axis/services/" + resource.getServiceName());
                epr.setAddress(endpoint_uri);
            }
        }
        catch (URI.MalformedURIException e) {
            System.exit(1);
        }
        ReferencePropertiesType rpt = new ReferencePropertiesType();
        rpt.set_any(new MessageElement[]{new MessageElement(WSAddressingHeaders.DISAMBIGUATOR_QNAME, (Object)disambiguator)});
        epr.setProperties(rpt);
        QName attr_qname = new QName("https://some.namespace", "Thing");
        epr.setPortType(new AttributedQName(attr_qname));
        return epr;
    }

    public Object lookupResource(EndpointReferenceType epr) throws ResourceUnknownFaultType {
        Object resource = this.resources.get(epr.getProperties().get(WSAddressingHeaders.DISAMBIGUATOR_QNAME).getValue());
        if (resource == null) {
            throw new ResourceUnknownFaultType();
        }
        return resource;
    }

    public void deleteResource(EndpointReferenceType epr) {
        this.resources.remove(epr.getProperties().get(WSAddressingHeaders.DISAMBIGUATOR_QNAME).getValue());
    }

    private static synchronized void init() {
        if (!initialized) {
            resourceManager = new ResourceManager();
            initialized = true;
            resourceChecker = new Timer();
            timer = resourceManager.new LifetimeChecker();
            resourceChecker.schedule((TimerTask)timer, DELAY, DELAY);
        }
    }

    private class LifetimeChecker
    extends TimerTask {
        LifetimeChecker() {
        }

        public void run() {
        }
    }
}

