/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.util;

import com.fujitsu.unicore.services.impl.job.JobImpl;
import com.fujitsu.unicore.services.resourcemgmt.DynamicResourceProperty;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import com.fujitsu.unicore.services.util.IUnicoreServer;
import com.fujitsu.unicore.services.util.JobProperties;
import com.fujitsu.unicore.services.util.StatusType;
import com.fujitsu.unicore.services.util.UnicoreServer;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.oasis.wsrf.bf.BaseFaultType;
import org.oasis.wsrf.rp.InvalidInsertResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.rp.ResourceUnknownFaultType;

public class JobManager {
    private UnicoreServer unicore;
    private static int unique_job_identifier = new Random(new Date().getTime()).nextInt();
    private IUnicoreServer.JobManagement unicore_jobm;
    private JobProperties jp;

    public JobManager() {
        MessageContext msgCtxt = MessageContext.getCurrentContext();
        SOAPService handler = msgCtxt.getService();
        String gateway_url = (String)handler.getOption("unicore.gateway_url");
        String vsite_name = (String)handler.getOption("unicore.vsite_name");
        File keystore_file = new File(String.valueOf(System.getProperty("path")) + File.separator + (String)handler.getOption("unicore.keystore_file_name"));
        String password = (String)handler.getOption("unicore.password");
        UnicoreServer unicore = new UnicoreServer();
        try {
            unicore.init(gateway_url, vsite_name, keystore_file, password, null);
        }
        catch (BaseFaultType bf) {
            bf.printStackTrace();
        }
        this.unicore = unicore;
    }

    public void submit(String jsdl_doc) {
        this.unicore_jobm = this.unicore.createjobManagement(unique_job_identifier++);
        try {
            this.unicore_jobm.submit(jsdl_doc);
        }
        catch (ResourceUnknownFaultType e) {
            e.printStackTrace();
        }
        catch (BaseFaultType e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public EndpointReferenceType createJobService() {
        this.jp = new JobProperties();
        GregorianCalendar terminationTime = new GregorianCalendar();
        terminationTime.add(12, 5);
        JobImpl jobImpl = new JobImpl("JobService", JobImpl.job_properties_qname, null, terminationTime);
        this.jp.setJobReference(jobImpl.getEndpointReferenceType());
        this.jp.setJobName(this.getJobName());
        JobStatusValue jsv = new JobStatusValue(JobImpl.status);
        this.jp.setStatus((StatusType)jsv.getProperty());
        JobOutPut jop = new JobOutPut(JobImpl.output);
        this.jp.setOutPut((String)jop.getProperty());
        ResourcePropertyObject[] rps = new ResourcePropertyObject[]{new ResourcePropertyObject(JobImpl.job_name, this.jp.getJobName()), new ResourcePropertyObject(JobImpl.job_reference, this.jp.getJobReference()), new ResourcePropertyObject(JobImpl.status, jsv), new ResourcePropertyObject(JobImpl.output, jop)};
        int i = 0;
        while (i < rps.length) {
            try {
                if (jobImpl.resourcePropertyExists(rps[i].getName())) {
                    jobImpl.addResourceProperty(rps[i]);
                } else {
                    jobImpl.registerResourceProperty(rps[i].getName(), true);
                    jobImpl.addResourceProperty(rps[i]);
                }
            }
            catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
                fault.printStackTrace();
            }
            catch (InvalidResourcePropertyQNameFaultType irpqf) {
                irpqf.printStackTrace();
            }
            ++i;
        }
        return this.jp.getJobReference();
    }

    public JobProperties getJobProperties() {
        return this.jp;
    }

    private String getJobStatus() {
        String status = null;
        try {
            status = this.unicore_jobm.getJobStatus();
        }
        catch (BaseFaultType e) {
            e.printStackTrace();
        }
        return status;
    }

    private String getJobName() {
        String name = null;
        try {
            name = this.unicore_jobm.getJobName();
        }
        catch (BaseFaultType e) {
            e.printStackTrace();
        }
        return name;
    }

    private String getStdOut() {
        String output = null;
        try {
            output = this.unicore_jobm.getStdout() != null ? new String(this.unicore_jobm.getStdout()) : "This Job has not finished execution yet";
        }
        catch (BaseFaultType e) {
            e.printStackTrace();
        }
        return output;
    }

    private String getStdErr() {
        String err = null;
        try {
            err = this.unicore_jobm.getStderr() != null ? new String(this.unicore_jobm.getStderr()) : "No error";
        }
        catch (BaseFaultType e) {
            e.printStackTrace();
        }
        return err;
    }

    private class JobStatusValue
    extends DynamicResourceProperty {
        public JobStatusValue(QName name) {
            super(name);
        }

        public Object getValue() {
            StatusType statusType = null;
            String status = JobManager.this.getJobStatus();
            statusType = status.equalsIgnoreCase("FAILED") ? StatusType.FAILED : (status.equalsIgnoreCase("QUEUED") ? StatusType.QUEUED : (status.equalsIgnoreCase("READY") ? StatusType.READY : (status.equalsIgnoreCase("RUNNING") ? StatusType.RUNNING : (status.equalsIgnoreCase("SUCCESSFUL") ? StatusType.SUCCESSFUL : StatusType.UNDEFINED))));
            return statusType;
        }
    }

    private class JobOutPut
    extends DynamicResourceProperty {
        public JobOutPut(QName name) {
            super(name);
        }

        public Object getValue() {
            return JobManager.this.getStdOut();
        }
    }
}

