/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.util;

import com.cineca.jsdl2ajo.JSDL2AJO;
import com.fujitsu.arcon.servlet.Connection;
import com.fujitsu.arcon.servlet.Gateway;
import com.fujitsu.arcon.servlet.Identity;
import com.fujitsu.arcon.servlet.JobManager;
import com.fujitsu.arcon.servlet.OutcomeTh;
import com.fujitsu.arcon.servlet.Reference;
import com.fujitsu.arcon.servlet.VsiteManager;
import com.fujitsu.arcon.servlet.VsiteTh;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import com.fujitsu.unicore.services.util.IUnicoreServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.oasis.wsrf.bf.BaseFaultType;
import org.oasis.wsrf.bf.BaseFaultTypeDescription;
import org.oasis.wsrf.rp.ResourceUnknownFaultType;
import org.unicore.AAIdentifier;
import org.unicore.AJOIdentifier;
import org.unicore.ajo.AbstractAction;
import org.unicore.ajo.AbstractJob;
import org.unicore.ajo.ExtendTerminationTime;
import org.unicore.ajo.GetActionStatus;
import org.unicore.ajo.GetResourceDescription;
import org.unicore.outcome.AbstractActionStatus;
import org.unicore.outcome.ExtendTerminationTime_Outcome;
import org.unicore.outcome.GetActionStatus_Outcome;
import org.unicore.outcome.GetResourceDescription_Outcome;
import org.unicore.outcome.Outcome;
import org.unicore.resources.AlternativeUspace;
import org.unicore.resources.NumericInfoResource;
import org.unicore.resources.Resource;
import org.unicore.sets.ResourceEnumeration;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class UnicoreServer
implements IUnicoreServer {
    VsiteTh vsite;
    private ResourcePropertyObject[] server_resources;

    public void init(String gateway_url, String vsite_name, File keystore_file, String password, X509Certificate[] user_identity) throws BaseFaultType {
        System.out.println("Creating a Unicore server, parms <" + gateway_url + "><" + vsite_name + "><" + keystore_file + ">");
        try {
            Identity identity = new Identity(keystore_file, password.toCharArray());
            Gateway gateway = new Gateway((Reference)new Reference.SSL(gateway_url, identity));
            VsiteManager.addGateway((Gateway)gateway);
            JobManager.listVsites((Gateway)gateway);
            JobManager.setOutcomeRootDirectory((File)new File("/tmp"));
            this.vsite = null;
            Iterator vsites = VsiteManager.getVsites();
            while (vsites.hasNext()) {
                VsiteTh vth = (VsiteTh)vsites.next();
                if (vth.getName().equalsIgnoreCase(vsite_name)) {
                    this.vsite = vth;
                }
                System.out.println("Gateway has Vsite <" + vth.getName() + ">");
            }
            if (this.vsite == null) {
                BaseFaultType bf = new BaseFaultType();
                bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("The Vsite <" + vsite_name + "> cannot be found at <" + gateway_url + ">")});
                throw bf;
            }
        }
        catch (Identity.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Errors processing Identity (keystore) in <" + keystore_file.getPath() + ">")});
            e.printStackTrace();
            throw bf;
        }
        catch (Gateway.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Errors contacting Gateway at <" + gateway_url + ">")});
            throw bf;
        }
        catch (Reference.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Errors generating reference from <" + gateway_url + "> <" + vsite_name + ">")});
            throw bf;
        }
        catch (JobManager.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Errors with Job at at <" + gateway_url + "> <" + vsite_name + ">")});
            throw bf;
        }
        catch (Connection.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Problems with connection to <" + gateway_url + ">")});
            throw bf;
        }
    }

    public String getVsiteName() {
        return this.vsite.getName();
    }

    public Integer getTotalNumberofJobs() throws BaseFaultType {
        GetResourceDescription grd = new GetResourceDescription("UnicoreWSRF server getResources action outcome");
        GetResourceDescription_Outcome outcome = (GetResourceDescription_Outcome)this.executeActionOnVsite((AbstractAction)grd);
        ResourceEnumeration re = outcome.getResources().elements();
        Integer total = null;
        while (re.hasMoreElements()) {
            Resource r = re.nextElement();
            if (!(r instanceof NumericInfoResource) || !((NumericInfoResource)r).getTag().equalsIgnoreCase("NJS Load")) continue;
            Double d = new Double(((NumericInfoResource)r).getValue());
            total = new Integer(d.intValue());
        }
        return total;
    }

    public IUnicoreServer.JobManagement createjobManagement(int job_identifier) {
        return new JobManagement(job_identifier, this);
    }

    public ResourcePropertyObject[] getServerResources() {
        return this.server_resources;
    }

    Outcome executeActionOnVsite(AbstractAction action) throws BaseFaultType {
        OutcomeTh outcome;
        try {
            outcome = JobManager.executeAction((AbstractAction)action, (VsiteTh)this.vsite);
        }
        catch (Connection.Exception e) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("WSRF action execution, problems with connection to <" + this.vsite.getReference().toString() + ">")});
            throw bf;
        }
        catch (JobManager.Exception e) {
            e.printStackTrace();
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("WSRF action execution, problems with getting job to <" + this.vsite.getReference().toString() + ">")});
            throw bf;
        }
        if (!outcome.getOutcome().getStatus().isEquivalent(AbstractActionStatus.SUCCESSFUL)) {
            BaseFaultType bf = new BaseFaultType();
            bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("WSRF action execution failed <" + outcome.getActionOutcome(action.getId()).getStatus() + "> because: " + outcome.getActionOutcome(action.getId()).getReason())});
            throw bf;
        }
        return outcome.getActionOutcome(action.getId());
    }

    public static class JobManagement
    implements IUnicoreServer.JobManagement {
        private AJOIdentifier identifier;
        private UnicoreServer parent;
        private Date termination_time;
        private AbstractActionStatus last_known_status = AbstractActionStatus.PENDING;
        private char[] stdout;
        private char[] stderr;

        public JobManagement(int job_identifier, UnicoreServer parent) {
            this.identifier = new AJOIdentifier("UniGrids Atomic Servies", job_identifier);
            this.parent = parent;
            AlternativeUspace target = new AlternativeUspace();
            target.setRequest(0.0);
            target.setUspace(this.identifier);
        }

        public void submit(String jsdl_doc) throws RemoteException, ResourceUnknownFaultType, BaseFaultType {
            BaseFaultType bf;
            System.out.println("Got a submit request");
            AbstractJob ajo = new AbstractJob();
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                JSDL2AJO handler = new JSDL2AJO(xr, "A");
                xr.setContentHandler((ContentHandler)handler);
                String jsdl_string = jsdl_doc;
                if (jsdl_string == null) {
                    System.out.println("No JSDL document passed in!");
                    BaseFaultType bf2 = new BaseFaultType();
                    bf2.setFaultDetailString("Please make sure a JSDL document has been sent from the client");
                    throw bf2;
                }
                StringReader sr = new StringReader(jsdl_string);
                xr.parse(new InputSource(sr));
                ajo = handler.getAJO();
                System.out.println(ajo.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e1) {
                e1.printStackTrace();
            }
            this.identifier.setName(ajo.getName());
            ajo.setId((AAIdentifier)this.identifier);
            try {
                String vn = this.parent.vsite.getName();
                String ajn = ajo.getName();
                System.out.println("Got a vsite :" + vn + ", for the job :" + ajn);
                JobManager.consignJob((AbstractJob)ajo, null, (VsiteTh)this.parent.vsite);
            }
            catch (Connection.Exception e) {
                bf = new BaseFaultType();
                bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Submit execution, problems with connection to <" + this.parent.vsite.getReference().toString() + ">")});
                throw bf;
            }
            catch (JobManager.Exception e) {
                e.printStackTrace();
                bf = new BaseFaultType();
                bf.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("Submit execution, problems with getting job to <" + this.parent.vsite.getReference().toString() + ">")});
                throw bf;
            }
            System.out.println("Executed submit request");
            System.out.println("The AJO Id is: < " + this.identifier + " >");
        }

        public String getJobStatus() throws BaseFaultType {
            block20: {
                if (this.last_known_status.isEquivalent(AbstractActionStatus.NOT_DONE)) {
                    GetActionStatus gas = new GetActionStatus("UnicoreWS server getStatus");
                    gas.setActionId((AAIdentifier)this.identifier);
                    GetActionStatus_Outcome gaso = (GetActionStatus_Outcome)this.parent.executeActionOnVsite((AbstractAction)gas);
                    System.out.println("Get job status: " + gaso.getStatus().toString() + " Job status was: " + gaso.getActionStatus().toString());
                    this.last_known_status = gaso.getActionStatus();
                    if (this.last_known_status.isEquivalent(AbstractActionStatus.DONE)) {
                        try {
                            OutcomeTh outcome = JobManager.getOutcome((AJOIdentifier)this.identifier, (VsiteTh)this.parent.vsite);
                            Map files_mapping = outcome.getFilesMapping();
                            if (files_mapping == null) break block20;
                            Collection c = files_mapping.values();
                            Iterator i = c.iterator();
                            while (i.hasNext()) {
                                Iterator j = ((Collection)i.next()).iterator();
                                while (j.hasNext()) {
                                    File f = (File)j.next();
                                    if (f.getName().endsWith("stdout")) {
                                        this.stdout = new char[(int)f.length()];
                                        try {
                                            new FileReader(f).read(this.stdout, 0, (int)f.length());
                                        }
                                        catch (FileNotFoundException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                    } else if (f.getName().endsWith("stderr")) {
                                        this.stderr = new char[(int)f.length()];
                                        try {
                                            new FileReader(f).read(this.stderr, 0, (int)f.length());
                                        }
                                        catch (FileNotFoundException e1) {
                                            e1.printStackTrace();
                                        }
                                        catch (IOException e1) {
                                            e1.printStackTrace();
                                        }
                                    }
                                    f.delete();
                                }
                            }
                        }
                        catch (JobManager.Exception e) {
                            e.printStackTrace();
                        }
                        catch (Connection.Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            if (this.last_known_status.isEquivalent(AbstractActionStatus.NOT_SUCCESSFUL)) {
                return "FAILED";
            }
            if (this.last_known_status.isEquivalent(AbstractActionStatus.PENDING)) {
                return "QUEUED";
            }
            if (this.last_known_status.isEquivalent(AbstractActionStatus.EXECUTING)) {
                return "RUNNING";
            }
            if (this.last_known_status.isEquivalent(AbstractActionStatus.CONSIGNED)) {
                return "RUNNING";
            }
            return this.last_known_status.toString();
        }

        public String getJobName() throws BaseFaultType {
            return this.identifier.getName();
        }

        public char[] getStdout() throws BaseFaultType {
            if (!this.last_known_status.isEquivalent(AbstractActionStatus.DONE)) {
                this.getJobStatus();
            }
            return this.stdout;
        }

        public char[] getStderr() throws BaseFaultType {
            if (!this.last_known_status.isEquivalent(AbstractActionStatus.DONE)) {
                this.getJobStatus();
            }
            return this.stdout;
        }

        public Date setTerminationTime(Date ttime) throws BaseFaultType {
            if (this.termination_time != null) {
                long offset = ttime.getTime() - this.termination_time.getTime();
                ExtendTerminationTime ett = new ExtendTerminationTime("GS extend");
                ett.setActionId((AAIdentifier)this.identifier);
                ett.setLength(offset);
                ExtendTerminationTime_Outcome tto = (ExtendTerminationTime_Outcome)this.parent.executeActionOnVsite((AbstractAction)ett);
                System.out.println("Termination Time outcome: " + tto.getStatus());
                if (tto.getStatus().isEquivalent(AbstractActionStatus.SUCCESSFUL)) {
                    this.termination_time = ttime;
                }
            } else {
                this.termination_time = ttime;
            }
            return this.termination_time;
        }
    }
}

