/*
 * Decompiled with CFR 0.152.
 */
import com.fujitsu.unicore.services.util.JobStatusType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.oasis.wsrf.bf.BaseFaultType;
import org.oasis.wsrf.rp.GetResourcePropertyResponse;
import org.oasis.wsrf.rp.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.rp.ResourceUnknownFaultType;
import org.unicore.services.wsrf.factory.CreateWSRF;
import org.unicore.services.wsrf.factory.CreateWSRFResponse;
import org.unicore.services.wsrf.factory.WSRFFactory;
import org.unicore.services.wsrf.factory.WSRFFactoryServiceLocator;
import org.unicore.services.wsrf.job.Job;
import org.unicore.services.wsrf.job.JobServiceAddressingLocator;
import org.unicore.services.wsrf.job.JobSoapBindingStub;
import org.unicore.services.wsrf.lt.ResourceLifetimePortType;
import org.unicore.services.wsrf.lt.ResourceLifetimeServiceAddressingLocator;
import org.unicore.services.wsrf.lt.ResourceLifetimeSoapBindingStub;
import org.unicore.services.wsrf.rp.ResourcePropertiesPortType;

public class UnicoreWSRF_Client
extends WSRF_Client {
    private static UnicoreWSRF_Client client;
    private static Job job;
    private URL factory_endpoint;
    private ResourceLifetimePortType wsrf;
    private static Map operations;

    static {
        operations = new HashMap();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Needs an endpoint for the WSRF factory (-Dtcp for via tcpmon)");
            System.exit(1);
        }
        String factory_endpoint = args[0];
        client = new UnicoreWSRF_Client(new URL(factory_endpoint));
        ResourceLifetimePortType wsrf = client.create(new URL(factory_endpoint));
        client.addOperation("man", client.new Manual());
        client.addOperation("quit", client.new Quit());
        client.addOperation("destroy", client.new Destroy());
        client.addOperation("settt", client.new SetTerminationTime());
        client.addOperation("insertrp", client.new Insert());
        client.addOperation("updaterp", client.new Update());
        client.addOperation("deleterp", client.new Delete());
        client.addOperation("grp", client.new Get());
        client.addOperation("gmrp", client.new GetMultiple());
        client.addOperation("grpd", client.new GetDocument());
        client.addOperation("gjob", client.new GetJob());
        BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line;
            System.out.print("\nwsrf services> ");
            try {
                line = inp.readLine();
                if (line == null) break;
                line = line.trim();
            }
            catch (IOException ioex) {
                break;
            }
            if (line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line);
            String command = st.nextToken().toLowerCase();
            Operation op = (Operation)operations.get(command);
            if (op == null) {
                System.out.println("-ERROR: Unrecognised command <" + command + ">");
                continue;
            }
            op.doOperation(st);
        }
    }

    public UnicoreWSRF_Client(URL factory_endpoint) {
        RPNameConverter.addPrefixNames("unicore", "http://unicore.org/services/types");
        RPNameConverter.addPrefixNames("jsdl", "http://schemas.ggf.org/jsdl/2005/06/jsdl");
        RPNameConverter.addQnameNames("JobStatus", new QName("http://unicore.org/services/types", "JobStatusType"));
        RPNameConverter.addQnameNames("Status", new QName("http://unicore.org/services/types", "StatusType"));
        RPNameConverter.addQnameNames("JobReference", new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReferenceType"));
        this.factory_endpoint = factory_endpoint;
    }

    private ResourceLifetimePortType create(URL factory_endpoint) {
        System.out.println("Creating a WSRF... (man command for operation mannul)\n");
        try {
            WSRFFactoryServiceLocator service = new WSRFFactoryServiceLocator();
            WSRFFactory factory = service.getWSRFFactoryService(factory_endpoint);
            CreateWSRFResponse create = factory.createWSRF(new CreateWSRF());
            EndpointReferenceType epr = create.getWsrfReference();
            System.out.println("EPR:Address\t= " + epr.getAddress());
            System.out.println("EPR:Ref Prop ResourceId\t= " + (epr.getProperties() == null ? "null props" : epr.getProperties().get_any()[0].getAsString()) + "\n");
            URI endpoint = null;
            if (System.getProperty("tcp") != null) {
                endpoint = new URI("http://localhost:" + Integer.parseInt(System.getProperty("tcp")) + epr.getAddress().getPath());
                epr.setAddress(new AttributedURI(endpoint));
            } else {
                endpoint = new URI(epr.getAddress().toString());
            }
            System.out.println("Rewritten EPR:Address     = " + endpoint + "\n");
            ResourceLifetimeServiceAddressingLocator wsrf_service = new ResourceLifetimeServiceAddressingLocator();
            this.wsrf = wsrf_service.getResourceLifetimePortType(epr);
            ((ResourceLifetimeSoapBindingStub)this.wsrf)._setProperty("ResourceDisambiguator", epr.getProperties().get_any()[0]);
        }
        catch (BaseFaultType ex) {
            System.out.println("BaseFault: " + ex.getMessage() + ":" + ex.getTimestamp().getTime());
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.wsrf;
    }

    private void addOperation(String tag, Operation op) {
        operations.put(tag, op);
    }

    abstract class Operation {
        Operation() {
        }

        public abstract String getManLine();

        public abstract void doOperation(StringTokenizer var1);
    }

    class Manual
    extends Operation {
        Manual() {
        }

        public String getManLine() {
            return "returns the available operations and arguments \nEvery operation must be followed by either \"wsrf\" or \"job\"\n where job refers to the most recent job from a gjob() method\nmost operations also have more arguments\n";
        }

        public void doOperation(StringTokenizer st) {
            Iterator i = operations.keySet().iterator();
            while (i.hasNext()) {
                String tag = (String)i.next();
                System.out.println("<" + tag + "> " + ((Operation)operations.get(tag)).getManLine());
            }
        }
    }

    class Quit
    extends Operation {
        Quit() {
        }

        public String getManLine() {
            return "quit application (will lose handle on Jobs and factory)";
        }

        public void doOperation(StringTokenizer st) {
            System.out.println("OK");
            System.exit(0);
        }
    }

    class Destroy
    extends Operation {
        Destroy() {
        }

        public String getManLine() {
            return "Destroy a resource";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.hasMoreTokens()) {
                    String service_name = st.nextToken();
                    if (service_name.equals("wsrf")) {
                        client.destroy(UnicoreWSRF_Client.this.wsrf);
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.destroy(job);
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to destroy");
                    }
                } else {
                    System.out.println("- ERROR: please provide a service instance");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class SetTerminationTime
    extends Operation {
        SetTerminationTime() {
        }

        public String getManLine() {
            return "Adjust termination time: extra arguement is offset in minutes";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() != 2) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.settt(UnicoreWSRF_Client.this.wsrf, Integer.parseInt(st.nextToken()));
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.settt(job, Integer.parseInt(st.nextToken()));
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to adjust time");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class Insert
    extends Operation {
        Insert() {
        }

        public String getManLine() {
            return "Inserts resource properties: extra arguements are pairs\nfirst value of pair is resource property name\nsecond value of pair is resource property value\n";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() < 3) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    ArrayList<String> values = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        String rp = st.nextToken();
                        values.add(rp);
                        if (!rp.startsWith("jsdl")) continue;
                        File jsdl_doc = new File(st.nextToken());
                        long length = jsdl_doc.length();
                        byte[] jsdl_bytes = new byte[(int)length];
                        FileInputStream in = new FileInputStream(jsdl_doc);
                        in.read(jsdl_bytes);
                        String jsdl = new String(jsdl_bytes);
                        values.add(jsdl);
                    }
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.insertrp(UnicoreWSRF_Client.this.wsrf, values);
                    } else if (job != null) {
                        client.insertrp(job, values);
                    } else {
                        System.out.println("-ERROR: please submit a job first");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class Update
    extends Operation {
        Update() {
        }

        public String getManLine() {
            return "Updates a existing resource: extra arguements are pairs\nfirst value of pair is resource property name\nsecond value of pair is resource property value\n";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() < 3) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    ArrayList<String> values = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        values.add(st.nextToken());
                    }
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.updaterp(UnicoreWSRF_Client.this.wsrf, values);
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.updaterp(job, values);
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to adjust time");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class Delete
    extends Operation {
        Delete() {
        }

        public String getManLine() {
            return "Delete resource properties: extra args are resource property qnames";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() < 2) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    String prop_name = st.nextToken();
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.deleterp(UnicoreWSRF_Client.this.wsrf, prop_name);
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.deleterp(job, prop_name);
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to delete resource property");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class Get
    extends Operation {
        Get() {
        }

        public String getManLine() {
            return "Get a resource property value from its qname: extra arguements is a pair\nfirst value of pair is resource property name\nsecond value of pair is resource property value\n";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() != 2) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    String prop_name = st.nextToken();
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.grp(UnicoreWSRF_Client.this.wsrf, prop_name);
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.grp(job, prop_name);
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to get a resource property");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class GetMultiple
    extends Operation {
        GetMultiple() {
        }

        public String getManLine() {
            return "Get multiple resource property values from their qnames: extra arguements are pairs\nfirst value of pair is resource property name\nsecond value of pair is resource property value\n";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() < 2) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String service_name = st.nextToken();
                    ArrayList<String> names = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        names.add(st.nextToken());
                    }
                    if (service_name.equalsIgnoreCase("wsrf")) {
                        client.gmrp(UnicoreWSRF_Client.this.wsrf, names.toArray(new String[names.size()]));
                    } else if (service_name.equals("job")) {
                        if (job != null) {
                            client.gmrp(job, names.toArray(new String[names.size()]));
                        } else {
                            System.out.println("-ERROR: please submit a job first");
                        }
                    } else {
                        System.out.println("-ERROR: please provide either wsrf or job to get multiple resource properties");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class GetDocument
    extends Operation {
        GetDocument() {
        }

        public String getManLine() {
            return "Get resource property document";
        }

        public void doOperation(StringTokenizer st) {
            try {
                String service_name;
                if (st.countTokens() != 1) {
                    System.out.println("-ERROR: insufficient arguments for this command");
                }
                if ((service_name = st.nextToken()).equalsIgnoreCase("wsrf")) {
                    client.grpd(UnicoreWSRF_Client.this.wsrf);
                } else if (service_name.equals("job")) {
                    if (job != null) {
                        client.grpd(job);
                    } else {
                        System.out.println("-ERROR: please submit a job first");
                    }
                } else {
                    System.out.println("-ERROR: please provide either wsrf or job to get multiple resource properties");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class GetJob
    extends Operation {
        static /* synthetic */ Class class$0;

        GetJob() {
        }

        public String getManLine() {
            return "Return a job: extra arguement for job name";
        }

        public void doOperation(StringTokenizer st) {
            try {
                if (st.countTokens() < 1) {
                    System.out.println("- ERROR: insufficient arguments for this command");
                } else {
                    String jobName = st.nextToken();
                    UnicoreWSRF_Client.job = this.getJob(jobName, "unicore:JobStatus", UnicoreWSRF_Client.this.wsrf);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private Job getJob(String jobName, String rp, Object service) {
            QName qn = null;
            try {
                qn = RPNameConverter.makeQName(rp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GetResourcePropertyResponse rpr = null;
            try {
                rpr = ((ResourcePropertiesPortType)service).getResourceProperty(qn);
            }
            catch (InvalidResourcePropertyQNameFaultType e) {
                e.printStackTrace();
            }
            catch (ResourceUnknownFaultType e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            Job job = null;
            MessageElement[] rps = rpr.get_any();
            int i = 0;
            while (i < rps.length) {
                if (rps[i].getValue() != null) {
                    System.out.println("<" + rps[i].getLocalName() + "> " + rps[i].getValue());
                } else {
                    try {
                        Object rpo = null;
                        if (rps[i].getLocalName().equals("JobStatus")) {
                            MessageElement messageElement = rps[i];
                            QName qName = RPNameConverter.getQNameType(rps[i].getLocalName());
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("com.fujitsu.unicore.services.util.JobStatusType");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            rpo = messageElement.getValueAsType(qName, (Class)clazz);
                        } else {
                            rpo = rps[i].getValueAsType(RPNameConverter.getQNameType(rps[i].getLocalName()));
                        }
                        if (rpo instanceof JobStatusType && jobName.equals(((JobStatusType)rpo).getJobName())) {
                            EndpointReferenceType job_epr = ((JobStatusType)rpo).getJobReference();
                            System.out.println("EPR:Address\t= " + job_epr.getAddress());
                            System.out.println("EPR:Ref Prop ResourceId\t= " + (job_epr.getProperties() == null ? "null props" : job_epr.getProperties().get_any()[0].getAsString()));
                            URI endpoint = null;
                            if (System.getProperty("tcp") != null) {
                                endpoint = new URI("http://localhost:" + Integer.parseInt(System.getProperty("tcp")) + job_epr.getAddress().getPath());
                                job_epr.setAddress(new AttributedURI(endpoint));
                            } else {
                                endpoint = new URI(job_epr.getAddress().toString());
                            }
                            System.out.println("Rewritten EPR:Address     = " + endpoint);
                            JobServiceAddressingLocator job_service = new JobServiceAddressingLocator();
                            job = job_service.getJobService(job_epr);
                            ((JobSoapBindingStub)job)._setProperty("ResourceDisambiguator", job_epr.getProperties().get_any()[0]);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            return job;
        }
    }
}

