/*
 * Decompiled with CFR 0.152.
 */
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import com.fujitsu.unicore.services.util.JobStatusType;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.oasis.wsrf.lt.Destroy;
import org.oasis.wsrf.lt.SetTerminationTime;
import org.oasis.wsrf.lt.SetTerminationTimeResponse;
import org.oasis.wsrf.rp.DeleteResourceProperties_Element;
import org.oasis.wsrf.rp.DeleteType;
import org.oasis.wsrf.rp.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.rp.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.rp.GetResourcePropertyDocumentResponse;
import org.oasis.wsrf.rp.GetResourcePropertyDocument_Element;
import org.oasis.wsrf.rp.GetResourcePropertyResponse;
import org.oasis.wsrf.rp.InsertResourceProperties_Element;
import org.oasis.wsrf.rp.InsertType;
import org.oasis.wsrf.rp.SetResourceProperties_Element;
import org.oasis.wsrf.rp.UpdateResourceProperties_Element;
import org.oasis.wsrf.rp.UpdateType;
import org.unicore.services.wsrf.lt.ResourceLifetimePortType;
import org.unicore.services.wsrf.rp.ResourcePropertiesPortType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSRF_Client {
    private static boolean TRACE = true;
    static /* synthetic */ Class class$0;

    public WSRF_Client() {
        RPNameConverter.addPrefixNames("wsrl", "http://docs.oasis-open.org/wsrf/2004/11/wsrf-WS-ResourceLifetime-1.2-draft-04.xsd");
        RPNameConverter.addPrefixNames("wsrp", "http://docs.oasis-open.org/wsrf/2004/11/wsrf-WS-ResourceProperties-1.2-draft-05.xsd");
    }

    protected void destroy(Object service_instance) {
        if (TRACE) {
            System.out.println("Destroy called.");
        }
        try {
            ((ResourceLifetimePortType)service_instance).destroy(new Destroy());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void settt(Object service_instance, int offset) {
        if (TRACE) {
            System.out.println("Set termination time. Offset <" + offset + ">");
        }
        try {
            GregorianCalendar req_tt = new GregorianCalendar();
            req_tt.add(12, offset);
            SetTerminationTime settt = new SetTerminationTime();
            settt.setRequestedTerminationTime(req_tt);
            SetTerminationTimeResponse settr = ((ResourceLifetimePortType)service_instance).setTerminationTime(settt);
            if (TRACE) {
                System.out.println("Successful");
                System.out.println("New Termination Time = " + settr.getNewTerminationTime().getTime().toString());
                System.out.println("Current Time         = " + settr.getCurrentTime().getTime().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void grp(Object service_instance, String rn) {
        if (TRACE) {
            System.out.println("Get resource property <" + rn + ">");
        }
        QName qn = null;
        try {
            qn = RPNameConverter.makeQName(rn);
        }
        catch (Exception e) {
            System.err.println("Get Resource Property failed making QName");
            e.printStackTrace();
            return;
        }
        GetResourcePropertyResponse rpr = null;
        try {
            rpr = ((ResourcePropertiesPortType)service_instance).getResourceProperty(qn);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        MessageElement[] rp = rpr.get_any();
        int i = 0;
        while (i < rp.length) {
            if (rp[i].getValue() != null) {
                System.out.println("<" + rp[i].getLocalName() + "> " + rp[i].getValue());
            } else {
                this.print_rp(rp[i]);
            }
            ++i;
        }
    }

    protected void gmrp(Object service_instance, String[] names) {
        QName[] qnames = new QName[names.length];
        int i = 0;
        while (i < names.length) {
            if (TRACE) {
                System.out.println("Get (multiple) resource property <" + names[i] + ">");
            }
            try {
                qnames[i] = RPNameConverter.makeQName(names[i]);
            }
            catch (Exception e) {
                System.err.println("Get (multiple) Resource Property failed making QName from <" + names[i] + ">");
                e.printStackTrace();
            }
            ++i;
        }
        GetMultipleResourceProperties_Element gmrp_e = new GetMultipleResourceProperties_Element();
        gmrp_e.setResourceProperty(qnames);
        GetMultipleResourcePropertiesResponse resp = null;
        try {
            resp = ((ResourcePropertiesPortType)service_instance).getMultipleResourceProperties(gmrp_e);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        MessageElement[] rps = resp.get_any();
        int i2 = 0;
        while (i2 < rps.length) {
            if (rps[i2].getValue() != null) {
                System.out.println("<" + rps[i2].getLocalName() + "> " + rps[i2].getValue());
            } else {
                this.print_rp(rps[i2]);
            }
            ++i2;
        }
    }

    protected void grpd(Object service_instance) {
        if (TRACE) {
            System.out.println("Get Resource property Document");
        }
        GetResourcePropertyDocumentResponse grpdr = null;
        try {
            grpdr = ((ResourcePropertiesPortType)service_instance).getResourcePropertyDocument(new GetResourcePropertyDocument_Element());
        }
        catch (Exception re) {
            re.printStackTrace();
            return;
        }
        MessageElement[] me = grpdr.get_any();
        int i = 0;
        while (i < me.length) {
            try {
                Iterator iterator = me[i].getChildElements();
                while (iterator.hasNext()) {
                    MessageElement rp = (MessageElement)iterator.next();
                    if (rp.getValue() != null) {
                        System.out.println("<" + rp.getLocalName() + "> " + rp.getValue());
                        continue;
                    }
                    this.print_rp(rp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void srp(Object service_instance, InsertType[] insert, UpdateType[] update, DeleteType[] delete) {
        if (TRACE) {
            System.out.println("Set Resource Properties");
        }
        SetResourceProperties_Element srp_e = new SetResourceProperties_Element();
        if (insert != null) {
            srp_e.setInsert(insert);
        }
        if (update != null) {
            srp_e.setUpdate(update);
        }
        if (delete != null) {
            srp_e.setDelete(delete);
        }
        try {
            ((ResourcePropertiesPortType)service_instance).setResourceProperties(srp_e);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void insertrp(Object service_instance, List values) {
        MessageElement[] me = new MessageElement[values.size() / 2];
        Iterator i = values.iterator();
        int counter = 0;
        while (i.hasNext()) {
            QName rp_name = null;
            try {
                rp_name = RPNameConverter.makeQName(i.next().toString());
            }
            catch (Exception e) {
                System.err.println("Error making QName in insert RP");
                e.printStackTrace();
                return;
            }
            ResourcePropertyObject rpo = new ResourcePropertyObject(rp_name, i.next());
            me[counter] = new MessageElement(rpo.getName(), rpo.getProperty());
            if (TRACE) {
                System.out.println("Insert ResourceProperties " + me[counter].getName() + ":\n" + me[counter].getValue().trim());
            }
            ++counter;
        }
        InsertType insert = new InsertType(me);
        InsertResourceProperties_Element insertRequest = new InsertResourceProperties_Element();
        insertRequest.setInsert(insert);
        try {
            ((ResourcePropertiesPortType)service_instance).insertResourceProperties(insertRequest);
        }
        catch (Exception re) {
            re.printStackTrace();
            return;
        }
    }

    protected void updaterp(Object service_instance, List values) {
        MessageElement[] me = new MessageElement[values.size() / 2];
        Iterator i = values.iterator();
        int counter = 0;
        while (i.hasNext()) {
            QName rp_name = null;
            try {
                rp_name = RPNameConverter.makeQName(i.next().toString());
            }
            catch (Exception e) {
                System.err.println("Failed converting QName in Update RP");
                e.printStackTrace();
                return;
            }
            ResourcePropertyObject rpo = new ResourcePropertyObject(rp_name, i.next());
            me[counter] = new MessageElement(rpo.getName(), rpo.getProperty());
            if (TRACE) {
                System.out.println("Update ResourceProperties <" + me[counter].getName() + ":" + me[counter].getValue() + ">");
            }
            ++counter;
        }
        UpdateType update = new UpdateType(me);
        UpdateResourceProperties_Element updateRequest = new UpdateResourceProperties_Element();
        updateRequest.setUpdate(update);
        try {
            ((ResourcePropertiesPortType)service_instance).updateResourceProperties(updateRequest);
        }
        catch (Exception re) {
            re.printStackTrace();
            return;
        }
    }

    protected void deleterp(Object service_instance, String prop_name) {
        if (TRACE) {
            System.out.println("DeleteResourceProperties <" + prop_name + ">");
        }
        QName qname = null;
        try {
            qname = RPNameConverter.makeQName(prop_name);
        }
        catch (Exception e) {
            System.err.println("Failed converting QName in Delete RP");
            e.printStackTrace();
        }
        DeleteType delete = new DeleteType(qname);
        DeleteResourceProperties_Element deleteRequest = new DeleteResourceProperties_Element();
        deleteRequest.setDelete(delete);
        try {
            ((ResourcePropertiesPortType)service_instance).deleteResourceProperties(deleteRequest);
            System.out.println("Delete resource property OK.");
        }
        catch (Exception re) {
            re.printStackTrace();
            return;
        }
    }

    protected void print_rp(MessageElement rp) {
        Object rpo = null;
        try {
            if (rp.getLocalName().equals("JobStatus")) {
                QName qName = RPNameConverter.getQNameType(rp.getLocalName());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.fujitsu.unicore.services.util.JobStatusType");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                rpo = rp.getValueAsType(qName, (Class)clazz);
            } else if (rp.getLocalName().equals("JobReference")) {
                System.out.println("<JobReference>");
                NodeList nl = rp.getAsDOM().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node node = nl.item(i);
                    if (node.getLocalName().equals("Address")) {
                        System.out.println(" <Address>" + node.getLastChild().getNodeValue());
                    } else if (node.getLocalName().equals("ReferenceProperties")) {
                        System.out.println(" <" + node.getLocalName() + ">\n" + "   <" + node.getFirstChild().getNodeName() + ">" + node.getFirstChild().getLastChild().getNodeValue() + "\n <" + node.getLocalName() + ">" + "\n<JobReference>");
                    }
                    ++i;
                }
            } else {
                rpo = rp.getValueAsType(RPNameConverter.getQNameType(rp.getLocalName()));
            }
            if (rpo instanceof EndpointReferenceType) {
                System.out.println("<" + rp.getLocalName() + "> " + ((EndpointReferenceType)rpo).getAddress().toString());
            } else if (rpo instanceof JobStatusType) {
                System.out.println("<" + rp.getLocalName() + "> " + "\n" + "  <Status> " + ((JobStatusType)rpo).getStatus() + "\n" + "  <JobReference>\n" + "     <Address> " + ((JobStatusType)rpo).getJobReference().getAddress().toString() + "\n" + "     <ReferenceProperties>\n" + "       " + ((JobStatusType)rpo).getJobReference().getProperties().get_any()[0].getAsString() + "\n" + "     </ReferenceProperties>\n" + "     </Address>\n" + "  <JobReference>\n" + "  <JobName> " + ((JobStatusType)rpo).getJobName() + "\n" + "</JobStatus>");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

