/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.impl.wsa;

import com.fujitsu.unicore.services.impl.wsa.WSAddressingHeaders;
import java.util.Iterator;
import java.util.List;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.uuid.SimpleUUIDGen;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.types.URI;

public class WSAddressingClientHandler
extends BasicHandler {
    private SimpleUUIDGen msgId;

    public void invoke(MessageContext context) throws AxisFault {
        context.setProperty("axis.transport.version", (Object)HTTPConstants.HEADER_PROTOCOL_V11);
        if (!context.getPastPivot()) {
            this.processClientRequest(context);
        } else {
            this.processClientResponse(context);
        }
    }

    public void onFault(MessageContext context) {
    }

    private void processClientRequest(MessageContext clientContextRequest) throws AxisFault {
        Message RequestMessage = clientContextRequest.getRequestMessage();
        try {
            SOAPEnvelope clientRequestEnvelope = RequestMessage.getSOAPEnvelope();
            this.msgId = new SimpleUUIDGen();
            String messageID = this.msgId.nextUUID();
            try {
                URI uriAction = new URI(clientContextRequest.getSOAPActionURI());
                URI uriMsgId = new URI("uuid", messageID);
                URI uriTo = new URI(clientContextRequest.getStrProp("transport.url"));
                WSAddressingHeaders wsaHeader = new WSAddressingHeaders((SOAPElement)clientContextRequest.getProperty("ResourceDisambiguator"), uriAction, uriMsgId, uriTo);
                wsaHeader.setRequestHeader((javax.xml.soap.SOAPEnvelope)clientRequestEnvelope);
            }
            catch (URI.MalformedURIException meI) {
                System.out.println(meI.getMessage());
                meI.printStackTrace();
            }
        }
        catch (Exception e) {
            AxisFault a_fault = AxisFault.makeFault((Exception)e);
            throw a_fault;
        }
    }

    private void processClientResponse(MessageContext clientContextResponse) throws AxisFault {
        Message responseMessage = clientContextResponse.getResponseMessage();
        try {
            SOAPHeader requestHeader = responseMessage.getSOAPEnvelope().getHeader();
            Iterator values = requestHeader.getChildElements();
            while (values.hasNext()) {
                SOAPHeaderElement selem = (SOAPHeaderElement)values.next();
                selem.setProcessed(true);
            }
        }
        catch (SOAPException soapE) {
            AxisFault a_fault = AxisFault.makeFault((Exception)((Object)soapE));
            throw a_fault;
        }
    }

    public List getUnderstoodHeaders() {
        return WSAddressingHeaders.getUnderstoodHeaders();
    }
}

