/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.impl.wsa;

import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.types.URI;

public class WSAddressingHeaders {
    public static final String REFERENCE_PROPERTY_NAME = "ResourceDisambiguator";
    public static final String REFERENCE_PROPERTY_NAMESPACE = "http://com.fujitsu.arcon.addressing";
    public static final QName DISAMBIGUATOR_QNAME = new QName("http://com.fujitsu.arcon.addressing", "ResourceDisambiguator");
    public static final String NS_ADDRESSDING_PRF = "wsa";
    public static final String NS_ADDRESSING_URI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    public static final String NS_ANONYMOUS = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
    public static final String ACTION = "Action";
    public static final String ADDRESS = "Address";
    public static final String MESSAGE_ID = "MessageID";
    public static final String TO = "To";
    public static final String FROM = "From";
    public static final String RELATES_TO = "RelatesTo";
    public static final String RELATIONSHIP_TYPE = "RelationshipType";
    public static final String REPLY_TO = "ReplyTo";
    public static final String RESPONSE = "Response";
    private SOAPElement reference_property_element;
    private URI action;
    private URI messageId;
    private URI to;
    private URI from;
    private URI relatesTo;

    public WSAddressingHeaders(SOAPElement reference_property_element, URI action, URI messageId, URI to, URI from, URI relatesTo) {
        this.reference_property_element = reference_property_element;
        this.action = action;
        this.messageId = messageId;
        this.to = to;
        this.from = from;
        this.relatesTo = relatesTo;
    }

    public WSAddressingHeaders(SOAPElement reference_property_element) {
        this.reference_property_element = reference_property_element;
        this.action = null;
        this.messageId = null;
        this.to = null;
        this.from = null;
        this.relatesTo = null;
    }

    public WSAddressingHeaders(URI action, URI messageId, URI to) {
        this.action = action;
        this.messageId = messageId;
        this.to = to;
        this.reference_property_element = null;
        this.from = null;
        this.relatesTo = null;
    }

    public WSAddressingHeaders(SOAPElement reference_property_element, URI action, URI messageId, URI to) {
        this.reference_property_element = reference_property_element;
        this.action = action;
        this.messageId = messageId;
        this.to = to;
        this.from = null;
        this.relatesTo = null;
    }

    public WSAddressingHeaders(URI action, URI messageId, URI to, URI from, URI relatesTo) {
        this.action = action;
        this.messageId = messageId;
        this.to = to;
        this.from = from;
        this.relatesTo = relatesTo;
        this.reference_property_element = null;
    }

    public SOAPElement getReferencePropertyElement() {
        return this.reference_property_element;
    }

    public void setReferencePropertyElement(SOAPElement reference_property_element) {
        this.reference_property_element = reference_property_element;
    }

    public URI getAction() {
        return this.action;
    }

    public void setAction(URI action) {
        this.action = action;
    }

    public URI getMessageId() {
        return this.messageId;
    }

    public void setMessageId(URI messageId) {
        this.messageId = messageId;
    }

    public URI getTo() {
        return this.to;
    }

    public void setTo(URI to) {
        this.to = to;
    }

    public URI getFrom() {
        return this.from;
    }

    public void setFrom(URI from) {
        this.from = from;
    }

    public URI getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelateTo(URI relatesTo) {
        this.relatesTo = relatesTo;
    }

    public void setRequestHeader(SOAPEnvelope inboundEnv) {
        try {
            Name nm;
            SOAPHeaderElement header_element;
            SOAPHeader requestHeader = inboundEnv.getHeader();
            inboundEnv.addNamespaceDeclaration(NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
            if (this.getReferencePropertyElement() != null) {
                SOAPElement elem = this.getReferencePropertyElement();
                Name nm2 = inboundEnv.createName(elem.getElementName().getLocalName(), elem.getElementName().getPrefix(), elem.getNamespaceURI(elem.getElementName().getPrefix()));
                header_element = requestHeader.addHeaderElement(nm2);
                header_element.addTextNode(elem.getValue());
                header_element.setMustUnderstand(true);
            }
            if (this.getAction() != null) {
                nm = inboundEnv.createName(ACTION, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header_element = requestHeader.addHeaderElement(nm);
                header_element.addTextNode(this.getAction().toString());
                header_element.setMustUnderstand(true);
            }
            if (this.getMessageId() != null) {
                nm = inboundEnv.createName(MESSAGE_ID, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header_element = requestHeader.addHeaderElement(nm);
                header_element.addTextNode(this.getMessageId().toString());
                header_element.setMustUnderstand(true);
            }
            if (this.getTo() != null) {
                nm = inboundEnv.createName(TO, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header_element = requestHeader.addHeaderElement(nm);
                header_element.addTextNode(this.getTo().toString());
                header_element.setMustUnderstand(true);
            }
        }
        catch (SOAPException se) {
            se.printStackTrace();
        }
    }

    public void setResponseHeader(SOAPEnvelope outboundEnv) {
        try {
            SOAPHeaderElement header;
            Name nm;
            SOAPHeader responseHeader = outboundEnv.getHeader();
            outboundEnv.addNamespaceDeclaration(NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
            if (this.getAction() != null) {
                nm = outboundEnv.createName(ACTION, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header = responseHeader.addHeaderElement(nm);
                header.addTextNode(this.getAction().toString());
                header.setMustUnderstand(true);
            }
            if (this.getMessageId() != null) {
                nm = outboundEnv.createName(MESSAGE_ID, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header = responseHeader.addHeaderElement(nm);
                header.addTextNode(this.getMessageId().toString());
                header.setMustUnderstand(true);
            }
            if (this.getTo() != null) {
                nm = outboundEnv.createName(TO, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header = responseHeader.addHeaderElement(nm);
                header.addTextNode(this.getTo().toString());
                header.setMustUnderstand(true);
            }
            if (this.getFrom() != null) {
                nm = outboundEnv.createName(FROM, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header = responseHeader.addHeaderElement(nm);
                SOAPElement soapE = header.addChildElement(ADDRESS, NS_ADDRESSDING_PRF);
                soapE.addTextNode(this.getFrom().toString());
                header.setMustUnderstand(true);
            }
            if (this.getRelatesTo() != null) {
                nm = outboundEnv.createName(RELATES_TO, NS_ADDRESSDING_PRF, NS_ADDRESSING_URI);
                header = responseHeader.addHeaderElement(nm);
                header.addTextNode(this.getRelatesTo().toString());
                Name name = outboundEnv.createName(RELATIONSHIP_TYPE);
                header.addAttribute(name, "wsa:Response");
                header.setMustUnderstand(true);
            }
        }
        catch (SOAPException se) {
            System.out.println(se.getMessage());
        }
    }

    public static List getUnderstoodHeaders() {
        System.out.println("Understand list created.");
        Vector<QName> understood = new Vector<QName>();
        understood.add(new QName(NS_ADDRESSING_URI, ACTION));
        understood.add(new QName(NS_ADDRESSING_URI, MESSAGE_ID));
        understood.add(new QName(NS_ADDRESSING_URI, TO));
        understood.add(new QName(NS_ADDRESSING_URI, FROM));
        return understood;
    }
}

