/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.impl.wsrf;

import com.fujitsu.unicore.services.resourcemgmt.DynamicResourceProperty;
import com.fujitsu.unicore.services.resourcemgmt.IResourcePropertiesManager;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertiesManager;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertySchemaChecker;
import com.fujitsu.unicore.services.util.JobManager;
import com.fujitsu.unicore.services.util.JobStatusType;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.oasis.wsrf.bf.BaseFaultTypeDescription;
import org.oasis.wsrf.rp.DeleteResourcePropertiesResponse;
import org.oasis.wsrf.rp.DeleteResourceProperties_Element;
import org.oasis.wsrf.rp.DeleteResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.rp.DeleteType;
import org.oasis.wsrf.rp.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.rp.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.rp.GetResourcePropertyDocumentResponse;
import org.oasis.wsrf.rp.GetResourcePropertyDocument_Element;
import org.oasis.wsrf.rp.GetResourcePropertyResponse;
import org.oasis.wsrf.rp.InsertResourcePropertiesResponse;
import org.oasis.wsrf.rp.InsertResourceProperties_Element;
import org.oasis.wsrf.rp.InsertResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.rp.InsertType;
import org.oasis.wsrf.rp.InvalidInsertResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.InvalidQueryExpressionFaultType;
import org.oasis.wsrf.rp.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.rp.InvalidSetResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.InvalidUpdateResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.QueryEvaluationErrorFaultType;
import org.oasis.wsrf.rp.QueryResourcePropertiesResponse;
import org.oasis.wsrf.rp.QueryResourceProperties_Element;
import org.oasis.wsrf.rp.ResourceUnknownFaultType;
import org.oasis.wsrf.rp.SetResourcePropertiesResponse;
import org.oasis.wsrf.rp.SetResourceProperties_Element;
import org.oasis.wsrf.rp.SetResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.rp.UnableToModifyResourcePropertyFaultType;
import org.oasis.wsrf.rp.UnknownQueryExpressionDialectFaultType;
import org.oasis.wsrf.rp.UpdateResourcePropertiesResponse;
import org.oasis.wsrf.rp.UpdateResourceProperties_Element;
import org.oasis.wsrf.rp.UpdateResourcePropertyRequestFailedFaultType;
import org.oasis.wsrf.rp.UpdateType;
import org.unicore.services.wsrf.rp.ResourcePropertiesPortType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourcePropertiesPortTypeImpl
extends ResourcePropertiesManager
implements ResourcePropertiesPortType {
    public ResourcePropertiesPortTypeImpl(String service_name, QName rp_document_qname, String rp_schema_filename) {
        super(service_name, rp_document_qname, rp_schema_filename);
    }

    public GetResourcePropertyDocumentResponse getResourcePropertyDocument(GetResourcePropertyDocument_Element getResourcePropertyDocumentRequest) throws RemoteException, ResourceUnknownFaultType {
        MessageElement[] rpdoc = this.getResourcePropertyDocument();
        MessageElement[] properties = new MessageElement[]{new MessageElement(this.getRPDocumemtQName())};
        int i = 0;
        while (i < rpdoc.length) {
            try {
                MessageElement temp;
                if (rpdoc[i].getValue() == null && (temp = this.resetMessageElement(rpdoc[i])) != null) {
                    rpdoc[i] = temp;
                }
                properties[0].addChild(rpdoc[i]);
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            ++i;
        }
        GetResourcePropertyDocumentResponse rpdr = new GetResourcePropertyDocumentResponse();
        rpdr.set_any(properties);
        return rpdr;
    }

    private MessageElement[] getResourcePropertyDocument() {
        Vector list = this.getAllResourceProperties();
        ResourcePropertyObject[] rp_document = list.toArray(new ResourcePropertyObject[list.size()]);
        Vector<ResourcePropertyObject> rp = new Vector<ResourcePropertyObject>();
        int i = 0;
        while (i < rp_document.length) {
            if (!rp_document[i].getName().equals(IResourcePropertiesManager.resourcePropertyNamesQName)) {
                rp.addElement(rp_document[i]);
            }
            ++i;
        }
        MessageElement[] me = new MessageElement[rp.size()];
        int j = 0;
        while (j < rp.size()) {
            ResourcePropertyObject rpo = (ResourcePropertyObject)rp.get(j);
            if (rpo.getProperty() instanceof DynamicResourceProperty) {
                rpo = new ResourcePropertyObject(rpo.getName(), ((DynamicResourceProperty)rpo.getProperty()).getProperty());
            }
            me[j] = new MessageElement(rpo.getName(), rpo.getProperty());
            ++j;
        }
        return me;
    }

    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, ResourceUnknownFaultType {
        QName[] qname = new QName[]{getResourcePropertyRequest};
        GetResourcePropertyResponse rpr = new GetResourcePropertyResponse();
        try {
            ResourcePropertyObject[] rpo = this.getResourceProperties(qname);
            MessageElement[] me = new MessageElement[rpo.length];
            int i = 0;
            while (i < rpo.length) {
                MessageElement temp;
                if (rpo[i].getProperty() instanceof DynamicResourceProperty) {
                    rpo[i] = new ResourcePropertyObject(rpo[i].getName(), ((DynamicResourceProperty)rpo[i].getProperty()).getProperty());
                }
                me[i] = new MessageElement(rpo[i].getName(), rpo[i].getProperty());
                if (me[i].getValue() == null && (temp = this.resetMessageElement(me[i])) != null) {
                    me[i] = temp;
                }
                ++i;
            }
            rpr.set_any(me);
            return rpr;
        }
        catch (Exception e) {
            e.printStackTrace();
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            fault.setDescription(new BaseFaultTypeDescription[]{new BaseFaultTypeDescription("The Resource Property for this qname does not exist!")});
            throw fault;
        }
    }

    public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(GetMultipleResourceProperties_Element getMultipleResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, ResourceUnknownFaultType {
        ResourcePropertyObject[] rp = new ResourcePropertyObject[getMultipleResourcePropertiesRequest.getResourceProperty().length];
        rp = this.getResourceProperties(getMultipleResourcePropertiesRequest.getResourceProperty());
        MessageElement[] me = new MessageElement[rp.length];
        int i = 0;
        while (i < rp.length) {
            MessageElement temp;
            if (rp[i].getProperty() instanceof DynamicResourceProperty) {
                rp[i] = new ResourcePropertyObject(rp[i].getName(), ((DynamicResourceProperty)rp[i].getProperty()).getProperty());
            }
            me[i] = new MessageElement(rp[i].getName(), rp[i].getProperty());
            if (me[i].getValue() == null && (temp = this.resetMessageElement(me[i])) != null) {
                me[i] = temp;
            }
            ++i;
        }
        GetMultipleResourcePropertiesResponse resp = new GetMultipleResourcePropertiesResponse();
        resp.set_any(me);
        return resp;
    }

    public SetResourcePropertiesResponse setResourceProperties(SetResourceProperties_Element setResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, UnableToModifyResourcePropertyFaultType, SetResourcePropertyRequestFailedFaultType, ResourceUnknownFaultType, InvalidSetResourcePropertiesRequestContentFaultType {
        ResourcePropertyObject rpo;
        int j;
        MessageElement[] me;
        int i;
        if (setResourcePropertiesRequest.getInsert() != null) {
            InsertType[] insert = setResourcePropertiesRequest.getInsert();
            i = 0;
            while (i < insert.length) {
                me = insert[i].get_any();
                j = 0;
                while (j < me.length) {
                    rpo = this.makeResourceProperty(me[j]);
                    if (this.resourcePropertyExists(rpo.getName())) {
                        ResourcePropertySchemaChecker checker = new ResourcePropertySchemaChecker(new File(this.getRPDocumentSchema()), this.getRPDocumemtQName().getLocalPart());
                        String[] occurs = checker.getOccursValue(rpo.getName().getLocalPart().toString());
                        if (!occurs[1].equals("unbounded") && Integer.parseInt(occurs[1]) <= this.resourcePropertyCount(rpo.getName())) {
                            InvalidInsertResourcePropertiesRequestContentFaultType fault = new InvalidInsertResourcePropertiesRequestContentFaultType();
                            fault.setFaultDetailString("Resource property already exists, schema only allows " + occurs[1] + " set of value");
                            throw fault;
                        }
                        this.addResourceProperty(rpo);
                    } else {
                        try {
                            this.registerResourceProperty(rpo.getName(), true);
                        }
                        catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
                            fault.printStackTrace();
                            throw fault;
                        }
                        this.addResourceProperty(rpo);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (setResourcePropertiesRequest.getUpdate() != null) {
            UpdateType[] update = setResourcePropertiesRequest.getUpdate();
            i = 0;
            while (i < update.length) {
                me = update[i].get_any();
                j = 0;
                while (j < me.length) {
                    rpo = this.makeResourceProperty(me[j]);
                    this.clearResourceProperty(rpo.getName());
                    this.addResourceProperty(rpo);
                    ++j;
                }
                ++i;
            }
        }
        if (setResourcePropertiesRequest.getDelete() != null) {
            DeleteType[] delete = setResourcePropertiesRequest.getDelete();
            i = 0;
            while (i < delete.length) {
                QName qname = delete[i].getResourceProperty();
                ResourcePropertySchemaChecker checker = new ResourcePropertySchemaChecker(new File(this.getRPDocumentSchema()), this.getRPDocumemtQName().getLocalPart());
                String[] occurs = checker.getOccursValue(qname.getLocalPart().toString());
                int rps = this.resourcePropertyCount(qname);
                if (!occurs[0].equals("unbounded") && rps != 0 && Integer.parseInt(occurs[0]) >= rps) {
                    throw new RemoteException("Delete this resource property is not allowed, schema requires at least " + occurs[0] + " value.");
                }
                this.deleteResourceProperty(qname);
                ++i;
            }
        }
        return new SetResourcePropertiesResponse();
    }

    public InsertResourcePropertiesResponse insertResourceProperties(InsertResourceProperties_Element insertResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, InsertResourcePropertyRequestFailedFaultType, UnableToModifyResourcePropertyFaultType, ResourceUnknownFaultType, InvalidInsertResourcePropertiesRequestContentFaultType {
        InsertType insert = insertResourcePropertiesRequest.getInsert();
        if (insert == null) {
            throw new RemoteException("No resource property to be inserted, check again.");
        }
        MessageElement[] me = insert.get_any();
        int i = 0;
        while (i < me.length) {
            ResourcePropertyObject rpo = this.makeResourceProperty(me[i]);
            if (this.resourcePropertyExists(rpo.getName())) {
                this.addResourceProperty(rpo);
            } else {
                try {
                    this.registerResourceProperty(rpo.getName(), true);
                }
                catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
                    fault.printStackTrace();
                    throw fault;
                }
                this.addResourceProperty(rpo);
            }
            if (rpo.getName().getLocalPart().equals("JSDL")) {
                String jsdl_doc = rpo.getProperty().toString();
                System.out.println(jsdl_doc);
                JobManager job = new JobManager();
                job.submit(jsdl_doc);
                EndpointReferenceType epr = job.createJobService();
                JobStatusType status = new JobStatusType();
                status.setJobName(job.getJobProperties().getJobName());
                status.setJobReference(job.getJobProperties().getJobReference());
                status.setStatus(job.getJobProperties().getStatus());
                ResourcePropertyObject rp = new ResourcePropertyObject(new QName("http://unicore.org/services/types", "JobStatus"), status);
                if (this.resourcePropertyExists(rp.getName())) {
                    this.addResourceProperty(rp);
                } else {
                    try {
                        this.registerResourceProperty(rp.getName(), true);
                    }
                    catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
                        fault.printStackTrace();
                        throw fault;
                    }
                    this.addResourceProperty(rp);
                }
            }
            ++i;
        }
        return new InsertResourcePropertiesResponse();
    }

    public UpdateResourcePropertiesResponse updateResourceProperties(UpdateResourceProperties_Element updateResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, UpdateResourcePropertyRequestFailedFaultType, InvalidUpdateResourcePropertiesRequestContentFaultType, UnableToModifyResourcePropertyFaultType, ResourceUnknownFaultType {
        UpdateType update = updateResourcePropertiesRequest.getUpdate();
        MessageElement[] me = update.get_any();
        int i = 0;
        while (i < me.length) {
            ResourcePropertyObject rpo = this.makeResourceProperty(me[i]);
            this.clearResourceProperty(rpo.getName());
            this.addResourceProperty(rpo);
            ++i;
        }
        return new UpdateResourcePropertiesResponse();
    }

    public DeleteResourcePropertiesResponse deleteResourceProperties(DeleteResourceProperties_Element deleteResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, DeleteResourcePropertyRequestFailedFaultType, UnableToModifyResourcePropertyFaultType, ResourceUnknownFaultType {
        DeleteType delete = deleteResourcePropertiesRequest.getDelete();
        QName qname = delete.getResourceProperty();
        ResourcePropertySchemaChecker checker = new ResourcePropertySchemaChecker(new File(this.getRPDocumentSchema()), this.getRPDocumemtQName().getLocalPart());
        String[] occurs = checker.getOccursValue(qname.getLocalPart().toString());
        int rps = this.resourcePropertyCount(qname);
        if (!occurs[0].equals("unbounded") && rps != 0 && Integer.parseInt(occurs[0]) >= rps) {
            throw new RemoteException("Delete this resource property is not allowed, schema requires at least " + occurs[0] + " value.");
        }
        this.deleteResourceProperty(qname);
        return new DeleteResourcePropertiesResponse();
    }

    public QueryResourcePropertiesResponse queryResourceProperties(QueryResourceProperties_Element queryResourcePropertiesRequest) throws RemoteException, InvalidResourcePropertyQNameFaultType, InvalidQueryExpressionFaultType, QueryEvaluationErrorFaultType, ResourceUnknownFaultType, UnknownQueryExpressionDialectFaultType {
        return null;
    }

    private MessageElement resetMessageElement(MessageElement me) {
        Element el = null;
        try {
            el = me.getAsDOM();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageElement reset_me = null;
        if (me.getNamespaceURI().equals(el.getFirstChild().getNamespaceURI()) && me.getLocalName().equals(el.getFirstChild().getLocalName())) {
            MessageElement temp = new MessageElement(new QName(el.getFirstChild().getNamespaceURI(), el.getFirstChild().getNodeName()));
            NodeList nl = el.getFirstChild().getChildNodes();
            int j = 0;
            while (j < nl.getLength()) {
                MessageElement child = null;
                Node node = nl.item(j);
                child = !node.hasChildNodes() ? new MessageElement(new QName(node.getNodeName())) : (node.getFirstChild().getNodeValue() != null ? new MessageElement(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node.getFirstChild().getNodeValue()) : new MessageElement(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node.getChildNodes()));
                try {
                    temp.addChild(child);
                }
                catch (SOAPException soapE) {
                    soapE.printStackTrace();
                }
                ++j;
            }
            reset_me = temp;
        }
        return reset_me;
    }

    private ResourcePropertyObject makeResourceProperty(MessageElement me) {
        ResourcePropertyObject rpo = null;
        if (me.getValue() == null) {
            Element el = null;
            try {
                el = me.getAsDOM();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            rpo = new ResourcePropertyObject(me.getQName(), el);
        } else {
            rpo = new ResourcePropertyObject(me.getQName(), me.getValue());
        }
        return rpo;
    }
}

