/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.unicore.services.resourcemgmt;

import com.fujitsu.unicore.services.resourcemgmt.IResourcePropertiesManager;
import com.fujitsu.unicore.services.resourcemgmt.ResourcePropertyObject;
import com.fujitsu.unicore.services.resourcemgmt.WSResource;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.oasis.wsrf.rp.InvalidInsertResourcePropertiesRequestContentFaultType;
import org.oasis.wsrf.rp.InvalidResourcePropertyQNameFaultType;

public class ResourcePropertiesManager
extends WSResource
implements IResourcePropertiesManager {
    private Map resource_properties = Collections.synchronizedMap(new Hashtable());
    private Map read_only_flags = Collections.synchronizedMap(new Hashtable());
    private QName rp_document_qname;
    private String rp_schema_filename;

    public ResourcePropertiesManager(String service_name, QName rp_document_qname, String rp_schema_filename) {
        super(service_name);
        this.rp_document_qname = rp_document_qname;
        this.rp_schema_filename = rp_schema_filename;
        try {
            this.registerResourceProperty(IResourcePropertiesManager.resourcePropertyNamesQName, true);
        }
        catch (InvalidInsertResourcePropertiesRequestContentFaultType fault) {
            fault.printStackTrace();
        }
    }

    public QName getRPDocumemtQName() {
        return this.rp_document_qname;
    }

    public String getRPDocumentSchema() {
        return this.rp_schema_filename;
    }

    public void addResourceProperty(ResourcePropertyObject rp) throws InvalidResourcePropertyQNameFaultType {
        List rps = (List)this.resource_properties.get(rp.getName());
        if (rps == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            fault.setFaultDetailString("Resource Property name not recognised: " + rp.getName());
            throw fault;
        }
        rps.add(rp);
    }

    public void registerResourceProperty(QName rp_name, boolean read_only) throws InvalidInsertResourcePropertiesRequestContentFaultType {
        if (!this.resource_properties.containsKey(rp_name)) {
            this.read_only_flags.put(rp_name, new Boolean(read_only));
            this.resource_properties.put(rp_name, Collections.synchronizedList(new Vector()));
            try {
                this.addResourceProperty(new ResourcePropertyObject(IResourcePropertiesManager.resourcePropertyNamesQName, rp_name));
            }
            catch (InvalidResourcePropertyQNameFaultType e) {
                e.printStackTrace();
            }
        } else {
            throw new InvalidInsertResourcePropertiesRequestContentFaultType();
        }
    }

    public void clearResourceProperty(QName rp_name) throws InvalidResourcePropertyQNameFaultType {
        if (!this.resource_properties.containsKey(rp_name)) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            fault.setFaultDetailString("Resource Property name not recognised: " + rp_name);
            throw fault;
        }
        this.resource_properties.put(rp_name, Collections.synchronizedList(new Vector()));
    }

    public void deleteResourceProperty(QName rp_name) throws InvalidResourcePropertyQNameFaultType {
        if (!this.resource_properties.containsKey(rp_name)) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            fault.setFaultDetailString("Resource Property name not recognised: " + rp_name);
            throw fault;
        }
        this.resource_properties.remove(rp_name);
    }

    public ResourcePropertyObject[] getResourceProperties(QName[] names) throws InvalidResourcePropertyQNameFaultType {
        Vector list = new Vector();
        int j = 0;
        while (j < names.length) {
            List rps = (List)this.resource_properties.get(names[j]);
            if (rps != null) {
                List list2 = rps;
                synchronized (list2) {
                    list.addAll(rps);
                }
            } else {
                InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
                fault.setFaultDetailString("Resource Property name not recognised: " + names[j]);
                throw fault;
            }
            ++j;
        }
        return list.toArray(new ResourcePropertyObject[list.size()]);
    }

    protected Vector getAllResourceProperties() {
        Vector list = new Vector();
        Iterator qnames = this.resource_properties.keySet().iterator();
        while (qnames.hasNext()) {
            List rps;
            List list2 = rps = (List)this.resource_properties.get(qnames.next());
            synchronized (list2) {
                list.addAll(rps);
            }
        }
        return list;
    }

    public boolean resourcePropertyExists(QName name) {
        return this.resource_properties.containsKey(name);
    }

    public int resourcePropertyCount(QName name) {
        List rps = (List)this.resource_properties.get(name);
        if (rps != null) {
            return rps.size();
        }
        return 0;
    }

    public boolean isReadOnly(QName rp_qname) throws InvalidResourcePropertyQNameFaultType {
        if (!this.resource_properties.containsKey(rp_qname)) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            fault.setFaultDetailString("Resource Property name not recognised: " + rp_qname);
            throw fault;
        }
        return (Boolean)this.read_only_flags.get(rp_qname);
    }
}

