/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.PortType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EndpointReference
extends EndpointReferenceType {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.message.addressing.EndpointReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public EndpointReference(Address address) {
        this.setAddress(address);
    }

    public EndpointReference(URI uri) {
        this.setAddress(new Address(uri));
    }

    public EndpointReference(EndpointReferenceType endpoint) {
        super(endpoint);
    }

    public EndpointReference(String endpoint) throws URI.MalformedURIException {
        this.setAddress(new Address(new URI(endpoint)));
    }

    public EndpointReference(SOAPElement element) throws Exception {
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            if (!(child instanceof SOAPElement) || !"http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(child.getNamespaceURI())) continue;
            String localName = child.getLocalName();
            if ("Address".equals(localName)) {
                Address address = Address.fromSOAPElement((SOAPElement)child);
                this.setAddress(address);
                continue;
            }
            if ("PortType".equals(localName)) {
                PortType portType = PortType.fromSOAPElement((SOAPElement)child);
                this.setPortType(portType);
                continue;
            }
            if ("ServiceName".equals(localName)) {
                ServiceNameType serviceName = ServiceNameType.fromSOAPElement((SOAPElement)child);
                this.setServiceName(serviceName);
                continue;
            }
            if (!"ReferenceProperties".equals(localName)) continue;
            ReferencePropertiesType props = ReferencePropertiesType.fromSOAPElement((SOAPElement)child);
            this.setProperties(props);
        }
    }

    public EndpointReference(Element element) throws Exception {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            org.w3c.dom.Node child = children.item(i);
            if (child instanceof Element && "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(child.getNamespaceURI())) {
                String localName = child.getLocalName();
                if ("Address".equals(localName)) {
                    Address address = Address.fromElement((Element)child);
                    this.setAddress(address);
                } else if ("PortType".equals(localName)) {
                    PortType portType = PortType.fromElement((Element)child);
                    this.setPortType(portType);
                } else if ("ServiceName".equals(localName)) {
                    ServiceNameType serviceName = ServiceNameType.fromElement((Element)child);
                    this.setServiceName(serviceName);
                } else if ("ReferenceProperties".equals(localName)) {
                    ReferencePropertiesType props = ReferencePropertiesType.fromElement((Element)child);
                    this.setProperties(props);
                }
            }
            ++i;
        }
    }

    public Element toDOM(Document doc) {
        return this.toDOM(doc, "EndpointReference");
    }

    public Element toDOM(Document doc, String elementName) {
        MessageElement[] any;
        ReferencePropertiesType referenceProperties;
        if (doc == null) {
            try {
                doc = XMLUtils.newDocument();
            }
            catch (ParserConfigurationException e) {
                return null;
            }
        }
        Element parent = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", elementName);
        if (doc.getDocumentElement() == null) {
            doc.appendChild(parent);
        } else {
            doc.getDocumentElement().appendChild(parent);
        }
        if (this.getAddress() != null) {
            this.getAddress().append(parent, "Address");
        }
        if (this.getPortType() != null) {
            this.getPortType().append(parent, "PortType");
        }
        if (this.getServiceName() != null) {
            this.getServiceName().append(parent, "ServiceName");
        }
        if ((referenceProperties = this.getProperties()) != null && referenceProperties.size() > 0) {
            referenceProperties.append(parent, "ReferenceProperties");
        }
        if ((any = this.get_any()) != null && any.length > 0) {
            int i = 0;
            while (i < any.length) {
                try {
                    parent.appendChild(doc.importNode(any[i].getAsDOM(), true));
                }
                catch (Exception e) {
                    log.debug((Object)"", (Throwable)e);
                }
                ++i;
            }
        }
        return parent;
    }

    public javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(javax.xml.soap.SOAPEnvelope env, String actorURI) throws Exception {
        return this.toSOAPHeaderElement(env, actorURI, "EndpointReference");
    }

    protected javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(javax.xml.soap.SOAPEnvelope env, String actorURI, String name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (!(env instanceof SOAPEnvelope)) {
            throw new Exception("Not supported");
        }
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        Document doc = XMLUtils.newDocument();
        SOAPHeaderElement headerElem = new SOAPHeaderElement(this.toDOM(doc, name));
        headerElem.setActor(actorURI);
        ((SOAPEnvelope)env).addHeader(headerElem);
        return headerElem;
    }
}

