/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.io.Serializable;
import javax.xml.namespace.QName;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedQName;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;

public class EndpointReferenceType
implements AnyContentType,
Serializable {
    private AttributedURI address;
    private AttributedQName portType;
    private ServiceNameType serviceName;
    private ReferencePropertiesType properties = new ReferencePropertiesType();
    private ReferenceParametersType parameters = new ReferenceParametersType();
    private MessageElement[] _any;
    private static TypeDesc typeDesc;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.axis.message.addressing.EndpointReferenceType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeDesc = new TypeDesc((Class)clazz, true);
        typeDesc.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReferenceType"));
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("address");
        elemField.setXmlName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address"));
        elemField.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "AttributedURI"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("properties");
        elemField.setXmlName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceProperties"));
        elemField.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferencePropertiesType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("parameters");
        elemField.setXmlName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceParameters"));
        elemField.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ReferenceParametersType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("portType");
        elemField.setXmlName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "PortType"));
        elemField.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "AttributedQName"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("serviceName");
        elemField.setXmlName(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceName"));
        elemField.setXmlType(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "ServiceNameType"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
    }

    public EndpointReferenceType() {
    }

    public EndpointReferenceType(URI address) {
        this.address = new AttributedURI(address);
    }

    public EndpointReferenceType(Address address) {
        this.address = address;
    }

    public EndpointReferenceType(EndpointReferenceType endpoint) {
        this(endpoint, false);
    }

    public EndpointReferenceType(EndpointReferenceType endpoint, boolean deepCopy) {
        if (deepCopy) {
            this.deepCopy(endpoint);
        } else {
            this.shallowCopy(endpoint);
        }
    }

    private void shallowCopy(EndpointReferenceType endpoint) {
        MessageElement[] any;
        ReferenceParametersType parameters;
        this.setAddress(endpoint.getAddress());
        this.setPortType(endpoint.getPortType());
        this.setServiceName(endpoint.getServiceName());
        ReferencePropertiesType properties = endpoint.getProperties();
        if (properties != null) {
            this.setProperties(new ReferencePropertiesType(properties, false));
        }
        if ((parameters = endpoint.getParameters()) != null) {
            this.setParameters(new ReferenceParametersType(parameters, false));
        }
        if ((any = endpoint.get_any()) != null && any.length > 0) {
            MessageElement[] newAny = new MessageElement[any.length];
            System.arraycopy(any, 0, newAny, 0, any.length);
            this.set_any(newAny);
        }
    }

    private void deepCopy(EndpointReferenceType endpoint) {
        ReferenceParametersType parameters;
        ReferencePropertiesType properties;
        ServiceNameType serviceName;
        AttributedQName port;
        AttributedURI address = endpoint.getAddress();
        if (address != null) {
            this.setAddress(new AttributedURI(address));
        }
        if ((port = endpoint.getPortType()) != null) {
            this.setPortType(new AttributedQName(port));
        }
        if ((serviceName = endpoint.getServiceName()) != null) {
            this.setServiceName(new ServiceNameType(serviceName));
        }
        if ((properties = endpoint.getProperties()) != null) {
            this.setProperties(new ReferencePropertiesType(properties, true));
        }
        if ((parameters = endpoint.getParameters()) != null) {
            this.setParameters(new ReferenceParametersType(parameters, true));
        }
        MessageElement elem = null;
        MessageElement[] any = endpoint.get_any();
        if (any != null) {
            MessageElement[] newAny = new MessageElement[any.length];
            int i = 0;
            while (i < any.length) {
                elem = any[i];
                try {
                    newAny[i] = new MessageElement(elem.getAsDOM());
                }
                catch (Exception e) {
                    newAny[i] = elem;
                }
                ++i;
            }
            this.set_any(newAny);
        }
    }

    public AttributedURI getAddress() {
        return this.address;
    }

    public void setAddress(AttributedURI address) {
        this.address = address;
    }

    public AttributedQName getPortType() {
        return this.portType;
    }

    public void setPortType(AttributedQName portType) {
        this.portType = portType;
    }

    public ReferencePropertiesType getProperties() {
        return this.properties;
    }

    public void setProperties(ReferencePropertiesType properties) {
        this.properties = properties;
    }

    public ReferenceParametersType getParameters() {
        return this.parameters;
    }

    public void setParameters(ReferenceParametersType parameters) {
        this.parameters = parameters;
    }

    public ServiceNameType getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameType serviceName) {
        this.serviceName = serviceName;
    }

    public MessageElement[] get_any() {
        return this._any;
    }

    public void set_any(MessageElement[] _any) {
        this._any = _any;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.address != null) {
            buf.append("Address: " + (Object)((Object)this.address));
            buf.append("\n");
        }
        if (this.portType != null) {
            buf.append("Port Type: " + this.portType);
            buf.append("\n");
        }
        if (this.serviceName != null) {
            buf.append("Service Name: " + this.serviceName);
            buf.append("\n");
            if (this.serviceName.getPort() != null) {
                buf.append("Port Name: " + this.serviceName.getPort());
                buf.append("\n");
            }
        }
        if (this.properties != null) {
            buf.append(this.properties);
        }
        if (this._any != null) {
            int i = 0;
            while (i < this._any.length) {
                buf.append("Extensibility Element[" + i + "]:\n");
                try {
                    buf.append(XMLUtils.ElementToString((Element)this._any[i].getAsDOM()));
                }
                catch (Exception e) {
                    buf.append("<error converting: " + e.getMessage() + ">");
                }
                buf.append("\n");
                ++i;
            }
        }
        return buf.toString();
    }

    public static TypeDesc getTypeDesc() {
        return typeDesc;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanDeserializer(_javaType, _xmlType, typeDesc);
    }
}

