/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.addressing.uuid;

import java.lang.reflect.Method;
import javax.xml.rpc.JAXRPCException;
import org.apache.ws.addressing.uuid.UUIdGenerator;

public class JugUUIdGenerator
implements UUIdGenerator {
    private static final String JUG_UUIDGENERATOR_CLASSNAME = "org.doomdark.uuid.UUIDGenerator";
    private static final String JUG_WEBSITE_URL = "http://www.doomdark.org/doomdark/proj/jug/";
    private static Method generateUUIdMethod;
    private static Method newInstanceMethod;
    private ThreadLocal JUG_UUIDGENERATOR = new ThreadLocal(){

        protected synchronized Object initialValue() {
            try {
                return newInstanceMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };

    static {
        Class<?> jugUuidGenClass = null;
        try {
            jugUuidGenClass = Class.forName(JUG_UUIDGENERATOR_CLASSNAME);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Java UUID Generator (JUG) org.doomdark.uuid.UUIDGenerator not found. Please add jug.jar, from http://www.doomdark.org/doomdark/proj/jug/, to your classpath and restart.");
        }
        try {
            newInstanceMethod = jugUuidGenClass.getMethod("getInstance", new Class[0]);
            generateUUIdMethod = jugUuidGenClass.getMethod("generateTimeBasedUUID", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal error initializing Java UUID Generator (JUG) org.doomdark.uuid.UUIDGenerator.");
        }
    }

    public String generateUUId() {
        try {
            return generateUUIdMethod.invoke(this.JUG_UUIDGENERATOR.get(), new Object[0]).toString();
        }
        catch (Exception e) {
            throw new JAXRPCException((Throwable)e);
        }
    }
}

