/*
 * RandGenClient.java
 *
 * Created on 15th June 2005, 10:44
 */

import randgen.*;
import java.rmi.RemoteException;
/**
 * Program for demonstrating how to generate a set of random 
 * pairs of real numbers using the RanGen service. The inputs are
 * <count> - the number of pairs to be generated
 *  <service URL> - the URL for the FileStore service where the
 *                  output is to be stored (as xml).
 *  <dir> - the sub directory the output file is put in
 *  <FileName2D> - the name of the file
 * e.g. 
 *     <service URL> - http://howe.nesc.ed.ac.uk:8080/FileStore1/filestore
 *     <dir> - run1 (this does not have to exist beforehand)
 *     <FileName2D> - rand.xml 
 * The random pairs are generated within a specified bounding box.
 *
 * @author sara
 */
public class RandGenClient{

    public static void main(String[] args){
	if(args.length != 4){
	    System.err.println("Usage: RandGenClient <count> "+
			       "<service URL> <dir> <Filename2D> ");
	    System.exit(1);
	}
	try{

	    /* Create a new bounding box and 
	     * define boundaries (parallel to the x and y axis)
	     * for the random pairs.
	     */
	    final Box bound = new Box(-10,-10,10,10);

	    int count = Integer.parseInt(args[0]);

	    /* Create the FileName2D object which specifies the
	     * filename and directory the 2-D data will be stored in
	     * the FileStore service.  
	     */
	    FileName2D name = new FileName2D(args[2],args[3]);


	    /* Create URLFileName2D objects which wrap the
	     * FileName2D object up with the FileStore service
	     * URL. 
	     */
	    URLFileName2D ranFileOut = new URLFileName2D(name,args[1]);

	    /* Create a RandGen service object and call the
	     * generate method.
	     */
	    RandGen_Impl service = new RandGen_Impl();
	    RandomGen port = service.getRandomGenPort();
	    port.generate(bound,count,ranFileOut);
	}
	catch(RemoteException re){
	    System.err.println("Remote error: "+re.getMessage());
	}
	catch(NumberFormatException nfe){
	    System.err.println("Error extracting count from command line argument");
	}
	catch(GeneratorException ge){
	    System.err.println("Generator error "+ge.getMessage());
	}
    }
}
