/*
 * FileStoreWrapper.java
 *
 * Created on 5th July 2005, 13:46
 */

import javax.xml.rpc.Stub;
import java.rmi.RemoteException;
import filestore1.*;
/**
 * Class which wraps the calls to the FileStore methods
 * for storing, deleting, concatenating and listing files.
 * @author sara
 */
public class FileStoreWrapper{
    
    /** Deletes a file containing 1D data
     * @param name the name of the file to be deleted
     * @param dir the subdirectory in FileStore the file is in
     * @param store the URL of the FileStore service 
     * @return true if the file was deleted
     */
    public static boolean delete1D(String name, String dir, String store) {
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    FileName1D name1D = new FileName1D(dir,name);

	    port.delete1D(name1D);
	    return true;
	}
	catch(FileStoreException fse){
	    //System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }
    /** Deletes a file containing 2D data
     * @param name the name of the file to be deleted
     * @param dir the subdirectory in FileStore the file is in
     * @param store the URL of the FileStore service 
     * @return true if the file was deleted
     */
    public static boolean delete2D(String name, String dir, String store) {
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    FileName2D name2D = new FileName2D(dir,name);

	    port.delete2D(name2D);
	    return true;
	}
	catch(FileStoreException fse){
	    //System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }
    /** Deletes a file containing 3D data
     * @param name the name of the file to be deleted
     * @param dir the subdirectory in FileStore the file is in
     * @param store the URL of the FileStore service 
     * @return true if the file was deleted
     */
    public static boolean delete3D(String name, String dir, String store) {
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    FileName3D name3D = new FileName3D(dir,name);

	    port.delete3D(name3D);
	    return true;
	}
	catch(FileStoreException fse){
	    //System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }

    /** Concatenates files containing 1D data. 
     * @param names the names of the files to be concatenated
     * @param dirs the subdirectories in FileStore these files are in
     * @param out the name of the file to contain the concatenated data
     * @param store the URL of the FileStore service 
     * @return true if the concatenation is successful
     */
    public static boolean cat1D(String[] names, String[] dirs, 
			 String out, String outDir, String store){
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    if(names.length != dirs.length) return false;

	    FileName1D[] names1D = new FileName1D[names.length];

	    for(int i = 0; i < names.length;i++){
		names1D[i] = 
		    new FileName1D(dirs[i],names[i]);
	    }

	    FileName1D out1D = new FileName1D(outDir,out);
	    
	    port.concatenate1D(names1D,out1D);
	    return true;
	}
	catch(FileStoreException fse){
	    System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }
    /** Concatenates files containing 2D data. 
     * @param names the names of the files to be concatenated
     * @param dirs the subdirectories in FileStore these files are in
     * @param out the name of the file to contain the concatenated data
     * @param store the URL of the FileStore service 
     * @return true if the concatenation is successful
     */
    public static boolean cat2D(String[] names, String[] dirs, 
			 String out, String outDir, String store){
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    if(names.length != dirs.length) return false;

	    FileName2D[] names2D = new FileName2D[names.length];

	    for(int i = 0; i < names.length;i++){
		names2D[i] = 
		    new FileName2D(dirs[i],names[i]);
	    }

	    FileName2D out2D = new FileName2D(outDir,out);
	    
	    port.concatenate2D(names2D,out2D);
	    return true;
	}
	catch(FileStoreException fse){
	    System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }
    /** Concatenates files containing 3D data. 
     * @param names the names of the files to be concatenated
     * @param dirs the subdirectories in FileStore these files are in
     * @param out the name of the file to contain the concatenated data
     * @param store the URL of the FileStore service 
     * @return true if the concatenation is successful
     */
    public static boolean cat3D(String[] names, String[] dirs, 
			 String out, String outDir, String store){
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);

	    if(names.length != dirs.length) return false;

	    FileName3D[] names3D = new FileName3D[names.length];

	    for(int i = 0; i < names.length;i++){
		names3D[i] = 
		    new FileName3D(dirs[i],names[i]);
	    }

	    FileName3D out3D = new FileName3D(outDir,out);
	    
	    port.concatenate3D(names3D,out3D);
	    return true;
	}
	catch(FileStoreException fse){
	    System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
	return false;
    }
    /** Lists the files in the specified sub-directory of
     * FileStore
     * @param dir the subdirectory
     */
    public static void list(String dir, String store){
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);
	    port.list(dir);
	}
	catch(FileStoreException fse){
	    System.err.println(fse.getMessage());
	}
	catch(RemoteException re){
	}
    }

    public static ThreeDFile getThreeDFile(String name, 
					   String dir, String store){
	try{
	    FileStore_Impl service = new FileStore_Impl();
	    Storage port = service.getStoragePort();
	    ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
				      store);
	    FileName3D out3D = new FileName3D(dir,name);
	    ThreeDFile out = port.fetch3D(out3D);
	    return out;
	}
	catch(FileStoreException fse){
	    System.err.println("Exception when fetching 3D data "+
			       fse.getMessage());
	    System.exit(1);
	}
	catch(RemoteException re){
	    System.err.println("Remote exception when fetching "+
			       " 3D data "+re.getMessage());
	    System.exit(1);
	}
	return null;
    }
}
