/*
 * RegularExplorer.java 
 * Created 6th July 2005, 20:31
 */
import filestore1.ThreeDFile;
import randgen.Box;
import java.math.*;
/* Samples a surface. The area to be sampled and the number of
 * sampling points are given as inputs. The points are generated
 * on a grid within the defined area. 
 * The inputs are
 * <lcx> the x coordinate of the lower corner of the area
 * <lcy> the y coordinate of the lower corner of the area
 * <ucx> the x coordinate of the upper corner of the area
 * <ucy> the y coordinate of the upper corner of the area
 * <count> the number of points
 * <filename> the name of the file for the output (a postscript file)
 * <surface url> the url for the service which is being sampled
 * The program does not guarantee to generate the count number
 * of samples. But a number (fairly) close to that.
 */
public class RegularExplorer{

    public static final String surfaceURL = "http://server5.gs.unina.it:8080/PillarsOfWisdom/surface";

    public static ThreeDFile explore(double lowerX, double lowerY, double upperX, double upperY, int count){

	//check the number of samples is valid
	if(count <= 0){
	    System.err.println("Count should be > 0");
	    System.exit(1);
	}
	    
	//create a box defining the sampling area
	Box b = new Box(lowerX,lowerY,upperX,upperY);

	//the maximum number of points accepted by the
	//Surface service
	final int maxPoints = 20;
	double dx = upperX-lowerX;
	double dy = upperY-lowerY;

	//calculate nRepeat, where nRepeat*nRepeat is the number 
	//of times the surface will be sampled (to ensure 
	//maxPoints is not exceeded). Each sub-sample is
	//over a sub-section of the sampling area. The
	//areas all have the same dimensions.
	int nRepeat = 
	    (int)Math.ceil(Math.sqrt(count/maxPoints));

	//the number of points for each sampling
	int nxy = (int)Math.ceil(((double)count)/(nRepeat*nRepeat));

	//filename for the temporary 3D data file
	final String surfName = "TempSurf";

	//holds filenames for the results of 
	//of each of the surface samples
	String[] files = new String[nRepeat*nRepeat];

	//x coordinate of the lower corner of the
	//first sub-section to be sampled
	double lX=lowerX; 
	//upper corner of the first sub-section.
	double uX=lowerX+dx/nRepeat; 

	int k=0;
	for(int i =0; i< nRepeat ;i++){
	    double lY=lowerY;
	    double uY=lowerY+dy/nRepeat; 
	    for(int j =0; j< nRepeat ;j++){
		files[k]=surfName+k+".xml";
		Box bound = new Box(lX,lY,uX,uY);
		BigProbe.regular(bound,nxy,files[k],surfaceURL);
		lY=uY;
		uY+=dy/nRepeat; 
		k++;
	    }
	    lX=uX;
	    uX+=dx/nRepeat; 
	}

	//filename for the temporary file containing the concatenated
	//data
	final String surfFile = surfName+".xml";
	//concatenate the data
	BigProbe.concatenate3D(files,surfFile);

	return BigProbe.getOutput(surfFile);
    }
}
